/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_reader;

import io.vavr.control.Either;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.cardanofoundation.lob.app.blockchain_common.domain.CardanoNetwork;
import org.cardanofoundation.lob.app.blockchain_common.domain.ChainTip;
import org.cardanofoundation.lob.app.blockchain_common.domain.OnChainTxDetails;
import org.cardanofoundation.lob.app.blockchain_reader.BlockchainReaderPublicApiIF;
import org.cardanofoundation.lob.app.blockchain_reader.domain.LOBOnChainTxStatusRequest;
import org.cardanofoundation.lob.app.blockchain_reader.domain.LOBOnChainTxStatusResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;
import org.zalando.problem.ThrowableProblem;

public class BlockchainReaderPublicApi
implements BlockchainReaderPublicApiIF {
    private static final Logger log = LoggerFactory.getLogger(BlockchainReaderPublicApi.class);
    public static final String NETWORK_MISMATCH_S_S = "Network mismatch: %s != %s";
    public static final String NETWORK_MISMATCH = "NETWORK_MISMATCH";
    public static final String ERROR_FROM_THE_CLIENT_S = "Error from the client: %s";
    public static final String INTERNAL_SERVER_ERROR_REASON_S = "Internal server error, reason: %s";
    private final RestClient restClient;
    private final CardanoNetwork network;
    @Value(value="${lob.blockchain_reader.lob_follower_base_url:http://localhost:9090/api}")
    private String lobFollowerBaseUrl;

    @PostConstruct
    public void init() {
        log.info("BlockchainReaderPublicApi initialized with network: {}", (Object)this.network);
    }

    @Override
    public Either<Problem, ChainTip> getChainTip() {
        try {
            ChainTip chainTip = (ChainTip)this.restClient.get().uri("%s/v1/tip".formatted(this.lobFollowerBaseUrl), new Object[0]).retrieve().body(ChainTip.class);
            if (chainTip.getNetwork() != this.network) {
                ThrowableProblem problem = Problem.builder().withTitle(NETWORK_MISMATCH).withStatus((StatusType)Status.BAD_REQUEST).withDetail(NETWORK_MISMATCH_S_S.formatted(chainTip.getNetwork(), this.network)).build();
                return Either.left((Object)problem);
            }
            return Either.right((Object)chainTip);
        }
        catch (RestClientResponseException ex) {
            ThrowableProblem problem = Problem.builder().withTitle("CHAIN_TIP_ERROR").withStatus((StatusType)Status.BAD_REQUEST).withDetail(ERROR_FROM_THE_CLIENT_S.formatted(ex.getResponseBodyAsString())).build();
            return Either.left((Object)problem);
        }
        catch (RestClientException ex) {
            log.error("Error while fetching chain tip", (Throwable)ex);
            ThrowableProblem problem = Problem.builder().withTitle("CHAIN_TIP_ERROR").withStatus((StatusType)Status.INTERNAL_SERVER_ERROR).withDetail(INTERNAL_SERVER_ERROR_REASON_S.formatted(ex.getMessage())).build();
            return Either.left((Object)problem);
        }
    }

    @Override
    public Either<Problem, Optional<OnChainTxDetails>> getTxDetails(String transactionHash) {
        try {
            OnChainTxDetails txDetails = (OnChainTxDetails)this.restClient.get().uri("%s/v1/tx-details/%s".formatted(this.lobFollowerBaseUrl, transactionHash), new Object[0]).retrieve().body(OnChainTxDetails.class);
            if (Objects.requireNonNull(txDetails).getNetwork() != this.network) {
                ThrowableProblem problem = Problem.builder().withTitle(NETWORK_MISMATCH).withStatus((StatusType)Status.BAD_REQUEST).withDetail(NETWORK_MISMATCH_S_S.formatted(txDetails.getNetwork(), this.network)).build();
                return Either.left((Object)problem);
            }
            return Either.right(Optional.of(txDetails));
        }
        catch (RestClientResponseException ex) {
            String responseText;
            if (ex.getStatusCode().value() == 404 && (responseText = ex.getResponseBodyAsString()).contains("TX_NOT_FOUND")) {
                return Either.right(Optional.empty());
            }
            ThrowableProblem problem = Problem.builder().withTitle("TX_DETAILS_ERROR").withStatus((StatusType)Status.BAD_REQUEST).withDetail(ERROR_FROM_THE_CLIENT_S.formatted(ex.getResponseBodyAsString())).build();
            return Either.left((Object)problem);
        }
        catch (RestClientException ex) {
            log.error("Error while fetching tx details", (Throwable)ex);
            ThrowableProblem problem = Problem.builder().withTitle("TX_DETAILS_ERROR").withStatus((StatusType)Status.INTERNAL_SERVER_ERROR).withDetail(INTERNAL_SERVER_ERROR_REASON_S.formatted(ex.getMessage())).build();
            return Either.left((Object)problem);
        }
    }

    @Override
    public Either<Problem, Map<String, Boolean>> isOnChain(Set<String> transactionIds) {
        try {
            LOBOnChainTxStatusResponse lobOnChainDetailsResponse = (LOBOnChainTxStatusResponse)((RestClient.RequestBodySpec)this.restClient.post().uri("%s/v1/on-chain-statuses".formatted(this.lobFollowerBaseUrl), new Object[0])).body((Object)new LOBOnChainTxStatusRequest(transactionIds)).retrieve().body(LOBOnChainTxStatusResponse.class);
            if (lobOnChainDetailsResponse.getNetwork() != this.network) {
                ThrowableProblem problem = Problem.builder().withTitle(NETWORK_MISMATCH).withStatus((StatusType)Status.BAD_REQUEST).withDetail(NETWORK_MISMATCH_S_S.formatted(lobOnChainDetailsResponse.getNetwork(), this.network)).build();
                return Either.left((Object)problem);
            }
            return Either.right(lobOnChainDetailsResponse.getTransactionStatuses());
        }
        catch (RestClientResponseException ex) {
            ThrowableProblem problem = Problem.builder().withTitle("LOB_TX_STATUSES_ERROR").withStatus((StatusType)Status.BAD_REQUEST).withDetail(ERROR_FROM_THE_CLIENT_S.formatted(ex.getResponseBodyAsString())).build();
            return Either.left((Object)problem);
        }
        catch (RestClientException ex) {
            log.error("Error while fetching on-chain statuses", (Throwable)ex);
            ThrowableProblem problem = Problem.builder().withTitle("LOB_TX_STATUSES_ERROR").withStatus((StatusType)Status.INTERNAL_SERVER_ERROR).withDetail(INTERNAL_SERVER_ERROR_REASON_S.formatted(ex.getMessage())).build();
            return Either.left((Object)problem);
        }
    }

    public BlockchainReaderPublicApi(RestClient restClient, CardanoNetwork network) {
        this.restClient = restClient;
        this.network = network;
    }
}

