/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.service.transation_submit;

import com.bloxbean.cardano.client.transaction.util.TransactionUtil;
import com.bloxbean.cardano.client.util.JsonUtil;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.cardanofoundation.lob.app.blockchain_common.BlockchainException;
import org.cardanofoundation.lob.app.blockchain_publisher.service.transation_submit.BlockchainTransactionSubmissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardanoSubmitApiBlockchainTransactionSubmissionService
implements BlockchainTransactionSubmissionService {
    private static final Logger log = LoggerFactory.getLogger(CardanoSubmitApiBlockchainTransactionSubmissionService.class);
    private final String cardanoSubmitApiUrl;
    private final String blockfrostApiKey;
    private final HttpClient httpClient;
    private final int timeoutInSeconds;

    @Override
    public String submitTransaction(byte[] txData) {
        HttpRequest txTransactionSubmitPostRequest = HttpRequest.newBuilder().uri(URI.create(this.cardanoSubmitApiUrl)).POST(HttpRequest.BodyPublishers.ofByteArray(txData)).timeout(Duration.ofSeconds(this.timeoutInSeconds)).header("Content-Type", "application/cbor").header("project_id", this.blockfrostApiKey).build();
        HttpResponse<String> r = this.httpClient.send(txTransactionSubmitPostRequest, HttpResponse.BodyHandlers.ofString());
        if (r.statusCode() >= 200 && r.statusCode() < 300) {
            String json = r.body();
            JsonNode jNode = JsonUtil.parseJson((String)json);
            return jNode.asText();
        }
        throw new BlockchainException("Error submitting transaction: %s to CardanoSubmitApi. Response: %s - %s".formatted(TransactionUtil.getTxHash((byte[])txData), r.statusCode(), r.body()));
    }

    public CardanoSubmitApiBlockchainTransactionSubmissionService(String cardanoSubmitApiUrl, String blockfrostApiKey, HttpClient httpClient, int timeoutInSeconds) {
        this.cardanoSubmitApiUrl = cardanoSubmitApiUrl;
        this.blockfrostApiKey = blockfrostApiKey;
        this.httpClient = httpClient;
        this.timeoutInSeconds = timeoutInSeconds;
    }
}

