/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.service.dispatch;

import com.bloxbean.cardano.client.api.exception.ApiException;
import io.vavr.control.Either;
import jakarta.annotation.PostConstruct;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.cardanofoundation.lob.app.blockchain_common.BlockchainException;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.API1BlockchainTransactions;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.BlockchainPublishStatus;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.L1Submission;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.L1SubmissionData;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.TransactionEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.repository.TransactionEntityRepositoryGateway;
import org.cardanofoundation.lob.app.blockchain_publisher.service.API1L1TransactionCreator;
import org.cardanofoundation.lob.app.blockchain_publisher.service.dispatch.DispatchingStrategy;
import org.cardanofoundation.lob.app.blockchain_publisher.service.event_publish.LedgerUpdatedEventPublisher;
import org.cardanofoundation.lob.app.blockchain_publisher.service.transation_submit.TransactionSubmissionService;
import org.cardanofoundation.lob.app.organisation.OrganisationPublicApi;
import org.cardanofoundation.lob.app.organisation.domain.entity.Organisation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.zalando.problem.Problem;

@Service
public class BlockchainTransactionsDispatcher {
    private static final Logger log = LoggerFactory.getLogger(BlockchainTransactionsDispatcher.class);
    private final TransactionEntityRepositoryGateway transactionEntityRepositoryGateway;
    private final OrganisationPublicApi organisationPublicApi;
    private final API1L1TransactionCreator l1TransactionCreator;
    private final TransactionSubmissionService transactionSubmissionService;
    private final LedgerUpdatedEventPublisher ledgerUpdatedEventPublisher;
    private final DispatchingStrategy<TransactionEntity> dispatchingStrategy;
    @Value(value="${lob.blockchain_publisher.dispatcher.pullBatchSize:500}")
    private int pullTransactionsBatchSize = 50;

    @PostConstruct
    public void init() {
        log.info("BlockchainTransactionsDispatcher initialized with pullTransactionsBatchSize:{}", (Object)this.pullTransactionsBatchSize);
        log.info("DispatchStrategy:{}", (Object)this.dispatchingStrategy.getClass().getSimpleName());
    }

    @Transactional
    public void dispatchTransactions() {
        log.info("Dispatching txs to the cardano blockchain...");
        for (Organisation organisation : this.organisationPublicApi.listAll()) {
            String organisationId = organisation.getId();
            Set<TransactionEntity> transactionsBatch = this.transactionEntityRepositoryGateway.findAndLockTransactionsReadyToBeDispatched(organisationId, this.pullTransactionsBatchSize);
            Set<TransactionEntity> transactionToDispatch = this.dispatchingStrategy.apply(organisationId, transactionsBatch);
            HashSet<TransactionEntity> toUnlock = new HashSet<TransactionEntity>(transactionsBatch);
            toUnlock.removeAll(transactionToDispatch);
            this.transactionEntityRepositoryGateway.unlockTransactions(toUnlock);
            int dispatchTxCount = transactionToDispatch.size();
            log.info("Dispatching txs for organisationId:{}, tx count:{}", (Object)organisationId, (Object)dispatchTxCount);
            if (dispatchTxCount <= 0) continue;
            this.dispatchTransactionsBatch(organisationId, transactionToDispatch);
        }
    }

    private void dispatchTransactionsBatch(String organisationId, Set<TransactionEntity> transactionEntitiesBatch) {
        log.info("Dispatching passedTransactions for organisation: {}", (Object)organisationId);
        Optional<API1BlockchainTransactions> blockchainTransactionsM = this.createAndSendBlockchainTransactions(organisationId, transactionEntitiesBatch);
        if (blockchainTransactionsM.isEmpty()) {
            log.info("No more passedTransactions to dispatch for organisationId: {}", (Object)organisationId);
            return;
        }
        API1BlockchainTransactions blockchainTransactions = blockchainTransactionsM.orElseThrow();
        int submittedTxCount = blockchainTransactions.submittedTransactions().size();
        int remainingTxCount = blockchainTransactions.remainingTransactions().size();
        this.transactionEntityRepositoryGateway.unlockTransactions(blockchainTransactions.remainingTransactions());
        log.info("Submitted tx count:{}, remainingTxCount:{}", (Object)submittedTxCount, (Object)remainingTxCount);
    }

    private Optional<API1BlockchainTransactions> createAndSendBlockchainTransactions(String organisationId, Set<TransactionEntity> transactions) {
        log.info("Processing passedTransactions for organisation:{}, remaining size:{}", (Object)organisationId, (Object)transactions.size());
        if (transactions.isEmpty()) {
            log.info("No more passedTransactions to dispatch for organisation:{}", (Object)organisationId);
            return Optional.empty();
        }
        Either<Problem, Optional<API1BlockchainTransactions>> serialisedTxE = this.l1TransactionCreator.pullBlockchainTransaction(organisationId, transactions);
        if (serialisedTxE.isEmpty()) {
            log.warn("Error, there is more passedTransactions to dispatch for organisation:{}, actual issue:{}", (Object)organisationId, serialisedTxE.getLeft());
            return Optional.empty();
        }
        Optional serialisedTxM = (Optional)serialisedTxE.get();
        if (serialisedTxM.isEmpty()) {
            log.warn("No passedTransactions to dispatch for organisationId:{}", (Object)organisationId);
            return Optional.empty();
        }
        API1BlockchainTransactions serialisedTx = (API1BlockchainTransactions)serialisedTxM.orElseThrow();
        try {
            this.sendTransactionOnChainAndUpdateDb(serialisedTx);
            return Optional.of(serialisedTx);
        }
        catch (ApiException | BlockchainException e) {
            log.error("Error sending transaction on chain and / or updating db", e);
        }
        catch (Exception e) {
            log.error("Unexpected error while sending transaction on chain and / or updating db", (Throwable)e);
        }
        return Optional.empty();
    }

    private void sendTransactionOnChainAndUpdateDb(API1BlockchainTransactions blockchainTransactions) throws ApiException, InterruptedException {
        byte[] txData = blockchainTransactions.serialisedTxData();
        L1Submission l1SubmissionData = this.transactionSubmissionService.submitTransactionWithPossibleConfirmation(txData, blockchainTransactions.receiverAddress());
        String organisationId = blockchainTransactions.organisationId();
        Set<TransactionEntity> allTxs = blockchainTransactions.submittedTransactions();
        String txHash = l1SubmissionData.txHash();
        Optional<Long> txAbsoluteSlotM = l1SubmissionData.absoluteSlot();
        this.updateTransactionStatuses(txHash, txAbsoluteSlotM, blockchainTransactions);
        this.ledgerUpdatedEventPublisher.sendTxLedgerUpdatedEvents(organisationId, allTxs);
        log.info("Blockchain transaction submitted, l1SubmissionData:{}", (Object)l1SubmissionData);
    }

    private void updateTransactionStatuses(String txHash, Optional<Long> absoluteSlot, API1BlockchainTransactions blockchainTransactions) {
        for (TransactionEntity txEntity : blockchainTransactions.submittedTransactions()) {
            txEntity.setL1SubmissionData(Optional.of(L1SubmissionData.builder().transactionHash(txHash).absoluteSlot(absoluteSlot.orElse(null)).creationSlot(blockchainTransactions.creationSlot()).publishStatus(BlockchainPublishStatus.SUBMITTED).build()));
            this.transactionEntityRepositoryGateway.storeTransaction(txEntity);
        }
    }

    public BlockchainTransactionsDispatcher(TransactionEntityRepositoryGateway transactionEntityRepositoryGateway, OrganisationPublicApi organisationPublicApi, API1L1TransactionCreator l1TransactionCreator, TransactionSubmissionService transactionSubmissionService, LedgerUpdatedEventPublisher ledgerUpdatedEventPublisher, DispatchingStrategy<TransactionEntity> dispatchingStrategy) {
        this.transactionEntityRepositoryGateway = transactionEntityRepositoryGateway;
        this.organisationPublicApi = organisationPublicApi;
        this.l1TransactionCreator = l1TransactionCreator;
        this.transactionSubmissionService = transactionSubmissionService;
        this.ledgerUpdatedEventPublisher = ledgerUpdatedEventPublisher;
        this.dispatchingStrategy = dispatchingStrategy;
    }
}

