/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.service;

import java.util.Optional;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.LedgerDispatchStatus;
import org.cardanofoundation.lob.app.blockchain_common.domain.FinalityScore;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.BlockchainPublishStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class BlockchainPublishStatusMapper {
    private static final Logger log = LoggerFactory.getLogger(BlockchainPublishStatusMapper.class);

    public LedgerDispatchStatus convert(BlockchainPublishStatus blockchainPublishStatus, FinalityScore finalityScore) {
        return this.convert(Optional.of(blockchainPublishStatus), Optional.of(finalityScore));
    }

    public LedgerDispatchStatus convert(BlockchainPublishStatus blockchainPublishStatus) {
        return this.convert(Optional.of(blockchainPublishStatus), Optional.empty());
    }

    protected LedgerDispatchStatus convertToLedgerDispatchStatus(FinalityScore finalityScore) {
        return switch (finalityScore) {
            default -> throw new MatchException(null, null);
            case FinalityScore.VERY_LOW, FinalityScore.LOW, FinalityScore.MEDIUM -> LedgerDispatchStatus.DISPATCHED;
            case FinalityScore.HIGH, FinalityScore.VERY_HIGH, FinalityScore.ULTRA_HIGH -> LedgerDispatchStatus.COMPLETED;
            case FinalityScore.FINAL -> LedgerDispatchStatus.FINALIZED;
        };
    }

    public BlockchainPublishStatus convert(FinalityScore finalityScore) {
        return switch (finalityScore) {
            default -> throw new MatchException(null, null);
            case FinalityScore.VERY_LOW, FinalityScore.LOW, FinalityScore.MEDIUM -> BlockchainPublishStatus.VISIBLE_ON_CHAIN;
            case FinalityScore.HIGH, FinalityScore.VERY_HIGH, FinalityScore.ULTRA_HIGH -> BlockchainPublishStatus.COMPLETED;
            case FinalityScore.FINAL -> BlockchainPublishStatus.FINALIZED;
        };
    }

    public BlockchainPublishStatus convert(LedgerDispatchStatus ledgerDispatchStatus) {
        Optional<Object> blockchainPublishStatusM = switch (ledgerDispatchStatus) {
            default -> throw new MatchException(null, null);
            case LedgerDispatchStatus.NOT_DISPATCHED -> Optional.empty();
            case LedgerDispatchStatus.MARK_DISPATCH -> Optional.of(BlockchainPublishStatus.STORED);
            case LedgerDispatchStatus.DISPATCHED -> Optional.of(BlockchainPublishStatus.VISIBLE_ON_CHAIN);
            case LedgerDispatchStatus.COMPLETED -> Optional.of(BlockchainPublishStatus.COMPLETED);
            case LedgerDispatchStatus.FINALIZED -> Optional.of(BlockchainPublishStatus.FINALIZED);
        };
        return blockchainPublishStatusM.orElse((Object)BlockchainPublishStatus.STORED);
    }

    public LedgerDispatchStatus convert(Optional<BlockchainPublishStatus> blockchainPublishStatus, Optional<FinalityScore> cardanoFinalityScore) {
        return blockchainPublishStatus.map(status -> switch (status) {
            default -> throw new MatchException(null, null);
            case BlockchainPublishStatus.STORED, BlockchainPublishStatus.ROLLBACKED -> LedgerDispatchStatus.MARK_DISPATCH;
            case BlockchainPublishStatus.VISIBLE_ON_CHAIN, BlockchainPublishStatus.SUBMITTED -> LedgerDispatchStatus.DISPATCHED;
            case BlockchainPublishStatus.COMPLETED -> cardanoFinalityScore.map(this::convertToLedgerDispatchStatus).orElse(LedgerDispatchStatus.DISPATCHED);
            case BlockchainPublishStatus.FINALIZED -> LedgerDispatchStatus.FINALIZED;
        }).orElse(LedgerDispatchStatus.NOT_DISPATCHED);
    }
}

