/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.service;

import com.bloxbean.cardano.client.metadata.MetadataBuilder;
import com.bloxbean.cardano.client.metadata.MetadataList;
import com.bloxbean.cardano.client.metadata.MetadataMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Clock;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.AccountEvent;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.CostCenter;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Counterparty;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Currency;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Document;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Organisation;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Project;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.TransactionEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.TransactionItemEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Vat;
import org.cardanofoundation.lob.app.support.calc.BigDecimals;
import org.springframework.stereotype.Service;

@Service
public class API1MetadataSerialiser {
    public static final String VERSION = "1.1";
    private final Clock clock;

    public MetadataMap serialiseToMetadataMap(String organisationId, Set<TransactionEntity> transactions, long creationSlot) {
        MetadataMap globalMetadataMap = MetadataBuilder.createMap();
        globalMetadataMap.put("metadata", this.createMetadataSection(creationSlot));
        boolean organisationCollapsable = API1MetadataSerialiser.isOrganisationCollapsable(organisationId, transactions);
        if (organisationCollapsable) {
            globalMetadataMap.put("org", API1MetadataSerialiser.serialise(((TransactionEntity)((Object)transactions.stream().findFirst().orElseThrow())).getOrganisation()));
        }
        MetadataList txList = MetadataBuilder.createList();
        transactions.forEach(tx -> txList.add(API1MetadataSerialiser.serialise(tx, organisationCollapsable)));
        globalMetadataMap.put("type", "INDIVIDUAL_TRANSACTIONS");
        globalMetadataMap.put("data", txList);
        return globalMetadataMap;
    }

    private static boolean isOrganisationCollapsable(String organisationId, Set<TransactionEntity> transactions) {
        return transactions.stream().allMatch(tx -> tx.getOrganisation().getId().equals(organisationId));
    }

    private MetadataMap createMetadataSection(long creationSlot) {
        MetadataMap metadataMap = MetadataBuilder.createMap();
        Instant now = Instant.now(this.clock);
        metadataMap.put("creation_slot", BigInteger.valueOf(creationSlot));
        metadataMap.put("timestamp", DateTimeFormatter.ISO_INSTANT.format(now));
        metadataMap.put("version", VERSION);
        return metadataMap;
    }

    private static MetadataMap serialise(TransactionEntity transaction, boolean isCollapsableOrganisation) {
        MetadataMap metadataMap = MetadataBuilder.createMap();
        String id = transaction.getId();
        metadataMap.put("id", id);
        metadataMap.put("number", transaction.getInternalNumber());
        metadataMap.put("batch_id", transaction.getBatchId());
        metadataMap.put("type", transaction.getTransactionType().name());
        metadataMap.put("date", transaction.getEntryDate().toString());
        metadataMap.put("accounting_period", transaction.getAccountingPeriod().toString());
        MetadataList transactionItemsMetadataList = MetadataBuilder.createList();
        for (TransactionItemEntity txLine : transaction.getItems()) {
            transactionItemsMetadataList.add(API1MetadataSerialiser.serialise(txLine));
        }
        if (transactionItemsMetadataList.size() > 0) {
            metadataMap.put("items", transactionItemsMetadataList);
        }
        if (!isCollapsableOrganisation) {
            metadataMap.put("org", API1MetadataSerialiser.serialise(transaction.getOrganisation()));
        }
        return metadataMap;
    }

    private static MetadataMap serialise(CostCenter costCenter) {
        MetadataMap metadataMap = MetadataBuilder.createMap();
        metadataMap.put("cust_code", costCenter.getCustomerCode());
        metadataMap.put("name", costCenter.getName());
        return metadataMap;
    }

    private static MetadataMap serialise(Project project) {
        MetadataMap metadataMap = MetadataBuilder.createMap();
        metadataMap.put("cust_code", project.getCustomerCode());
        metadataMap.put("name", project.getName());
        return metadataMap;
    }

    private static MetadataMap serialise(Document document) {
        MetadataMap metadataMap = MetadataBuilder.createMap();
        metadataMap.put("number", document.getNum());
        metadataMap.put("currency", API1MetadataSerialiser.serialise(document.getCurrency()));
        document.getVat().ifPresent(vat -> metadataMap.put("vat", API1MetadataSerialiser.serialise(vat)));
        document.getCounterparty().ifPresent(counterparty -> metadataMap.put("counterparty", API1MetadataSerialiser.serialise(counterparty)));
        return metadataMap;
    }

    private static MetadataMap serialise(Counterparty counterparty) {
        MetadataMap counterpartyMap = MetadataBuilder.createMap();
        counterpartyMap.put("cust_code", counterparty.getCustomerCode());
        counterpartyMap.put("type", counterparty.getType().name());
        return counterpartyMap;
    }

    private static MetadataMap serialise(Currency currency) {
        MetadataMap metadataMap = MetadataBuilder.createMap();
        metadataMap.put("id", currency.getId());
        metadataMap.put("cust_code", currency.getCustomerCode());
        return metadataMap;
    }

    private static MetadataMap serialise(Vat vat) {
        MetadataMap vatMetadataMap = MetadataBuilder.createMap();
        vatMetadataMap.put("cust_code", vat.getCustomerCode());
        vatMetadataMap.put("rate", BigDecimals.normaliseEngineeringString((BigDecimal)vat.getRate()));
        return vatMetadataMap;
    }

    private static MetadataMap serialise(TransactionItemEntity transactionItemEntity) {
        MetadataMap metadataMap = MetadataBuilder.createMap();
        metadataMap.put("id", transactionItemEntity.getId());
        metadataMap.put("amount", BigDecimals.normaliseEngineeringString((BigDecimal)transactionItemEntity.getAmountFcy()));
        transactionItemEntity.getAccountEvent().ifPresent(accountEvent -> metadataMap.put("event", API1MetadataSerialiser.serialise(accountEvent)));
        transactionItemEntity.getProject().ifPresent(project -> metadataMap.put("project", API1MetadataSerialiser.serialise(project)));
        transactionItemEntity.getCostCenter().ifPresent(costCenter -> metadataMap.put("cost_center", API1MetadataSerialiser.serialise(costCenter)));
        metadataMap.put("fx_rate", BigDecimals.normaliseEngineeringString((BigDecimal)transactionItemEntity.getFxRate()));
        metadataMap.put("document", API1MetadataSerialiser.serialise(transactionItemEntity.getDocument()));
        return metadataMap;
    }

    private static MetadataMap serialise(AccountEvent accountEvent) {
        MetadataMap metadataMap = MetadataBuilder.createMap();
        metadataMap.put("code", accountEvent.getCode());
        metadataMap.put("name", accountEvent.getName());
        return metadataMap;
    }

    private static MetadataMap serialise(Organisation org) {
        MetadataMap metadataMap = MetadataBuilder.createMap();
        metadataMap.put("id", org.getId());
        metadataMap.put("name", org.getName());
        metadataMap.put("tax_id_number", org.getTaxIdNumber());
        metadataMap.put("currency_id", org.getCurrencyId());
        metadataMap.put("country_code", org.getCountryCode());
        return metadataMap;
    }

    public API1MetadataSerialiser(Clock clock) {
        this.clock = clock;
    }
}

