/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.repository;

import com.google.common.collect.Sets;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.BlockchainPublishStatus;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.TransactionEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.repository.TransactionEntityRepository;
import org.cardanofoundation.lob.app.blockchain_publisher.repository.TransactionItemEntityRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Limit;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class TransactionEntityRepositoryGateway {
    private static final Logger log = LoggerFactory.getLogger(TransactionEntityRepositoryGateway.class);
    private final TransactionEntityRepository transactionEntityRepository;
    private final TransactionItemEntityRepository transactionItemEntityRepository;
    private final Clock clock;
    @Value(value="${lob.blockchain_publisher.dispatcher.lock_timeout:PT3H}")
    private Duration lockTimeoutDuration;

    public Optional<TransactionEntity> findById(String txId) {
        return this.transactionEntityRepository.findById(txId);
    }

    public Set<TransactionEntity> findAndLockTransactionsReadyToBeDispatched(String organisationId, int pullTransactionsBatchSize) {
        Set<BlockchainPublishStatus> dispatchStatuses = BlockchainPublishStatus.toDispatchStatuses();
        Limit limit = Limit.of((int)pullTransactionsBatchSize);
        Set<TransactionEntity> transactionsByStatus = this.transactionEntityRepository.findFreeTransactionsByStatus(organisationId, dispatchStatuses, LocalDateTime.now(this.clock).minus(this.lockTimeoutDuration), limit);
        if (transactionsByStatus.isEmpty()) {
            return transactionsByStatus;
        }
        transactionsByStatus.forEach(tx -> tx.setLockedAt(LocalDateTime.now(this.clock)));
        this.transactionEntityRepository.saveAll(transactionsByStatus);
        return transactionsByStatus;
    }

    public Set<TransactionEntity> findDispatchedTransactionsThatAreNotFinalizedYet(String organisationId, Limit limit) {
        Set<BlockchainPublishStatus> notFinalisedButVisibleOnChain = BlockchainPublishStatus.notFinalisedButVisibleOnChain();
        return this.transactionEntityRepository.findDispatchedTransactionsThatAreNotFinalizedYet(organisationId, notFinalisedButVisibleOnChain, limit);
    }

    @Transactional
    public Set<TransactionEntity> storeOnlyNew(Set<TransactionEntity> transactionEntities) {
        log.info("StoreOnlyNewTransactions..., storeOnlyNewTransactions:{}", (Object)transactionEntities.size());
        Set txIds = transactionEntities.stream().map(TransactionEntity::getId).collect(Collectors.toSet());
        HashSet existingTransactions = new HashSet(this.transactionEntityRepository.findAllById(txIds));
        Sets.SetView newTransactions = Sets.difference(transactionEntities, existingTransactions);
        Set<TransactionEntity> newTxs = Stream.concat(this.transactionEntityRepository.saveAll((Iterable)newTransactions).stream(), existingTransactions.stream()).collect(Collectors.toSet());
        for (TransactionEntity tx : newTxs) {
            this.transactionItemEntityRepository.saveAll(tx.getItems());
        }
        return newTxs;
    }

    public void storeTransaction(TransactionEntity transactionEntity) {
        this.transactionEntityRepository.save((Object)transactionEntity);
    }

    public void storeTransactions(Set<TransactionEntity> successfullyUpdatedTxEntities) {
        this.transactionEntityRepository.saveAll(successfullyUpdatedTxEntities);
    }

    public void unlockTransactions(Set<TransactionEntity> transactionsBatch) {
        transactionsBatch.forEach(transactionEntity -> transactionEntity.setLockedAt(null));
        this.transactionEntityRepository.saveAll(transactionsBatch);
    }

    public TransactionEntityRepositoryGateway(TransactionEntityRepository transactionEntityRepository, TransactionItemEntityRepository transactionItemEntityRepository, Clock clock) {
        this.transactionEntityRepository = transactionEntityRepository;
        this.transactionItemEntityRepository = transactionItemEntityRepository;
        this.clock = clock;
    }

    public TransactionEntityRepository getTransactionEntityRepository() {
        return this.transactionEntityRepository;
    }

    public TransactionItemEntityRepository getTransactionItemEntityRepository() {
        return this.transactionItemEntityRepository;
    }

    public Clock getClock() {
        return this.clock;
    }

    public Duration getLockTimeoutDuration() {
        return this.lockTimeoutDuration;
    }
}

