/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.repository;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.BlockchainPublishStatus;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.reports.ReportEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.repository.ReportEntityRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Limit;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ReportEntityRepositoryGateway {
    private static final Logger log = LoggerFactory.getLogger(ReportEntityRepositoryGateway.class);
    private final ReportEntityRepository reportEntityRepository;

    @Transactional
    public Set<ReportEntity> storeOnlyNew(Set<ReportEntity> reportEntities) {
        log.info("Store only new..., store only new: {}", (Object)reportEntities.size());
        Set reportIds = reportEntities.stream().map(ReportEntity::getId).collect(Collectors.toSet());
        Set existingReportIds = new HashSet(this.reportEntityRepository.findAllById(reportIds)).stream().map(ReportEntity::getId).collect(Collectors.toSet());
        Set newReports = reportEntities.stream().filter(report -> !existingReportIds.contains(report.getId())).collect(Collectors.toSet());
        return new HashSet<ReportEntity>(this.reportEntityRepository.saveAll(newReports));
    }

    public Set<ReportEntity> findDispatchedReportsThatAreNotFinalizedYet(String organisationId, Limit limit) {
        Set<BlockchainPublishStatus> notFinalisedButVisibleOnChain = BlockchainPublishStatus.notFinalisedButVisibleOnChain();
        return this.reportEntityRepository.findDispatchedReportsThatAreNotFinalizedYet(organisationId, notFinalisedButVisibleOnChain, limit);
    }

    @Transactional
    public Set<ReportEntity> findReportsByStatus(String organisationId, int pullReportsBatchSize) {
        Set<BlockchainPublishStatus> dispatchStatuses = BlockchainPublishStatus.toDispatchStatuses();
        Limit limit = Limit.of((int)pullReportsBatchSize);
        return this.reportEntityRepository.findReportsByStatus(organisationId, dispatchStatuses, limit);
    }

    @Transactional
    public void storeReport(ReportEntity reportEntity) {
        this.reportEntityRepository.save((Object)reportEntity);
    }

    public ReportEntityRepositoryGateway(ReportEntityRepository reportEntityRepository) {
        this.reportEntityRepository = reportEntityRepository;
    }
}

