/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.job;

import jakarta.annotation.PostConstruct;
import org.cardanofoundation.lob.app.blockchain_publisher.service.WatchDogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"lob.blockchain_publisher.enabled"}, havingValue="true", matchIfMissing=true)
public class WatchDogJob {
    private static final Logger log = LoggerFactory.getLogger(WatchDogJob.class);
    private final WatchDogService watchDogService;
    @Value(value="${lob.blockchain_publisher.watchdog.tx_limit_per_org_pull_size:1000}")
    private int txStatusInspectionLimitPerOrgPullSize = 1000;

    @PostConstruct
    public void init() {
        log.info("WatchDogJob is enabled.");
    }

    @Scheduled(fixedDelayString="${lob.blockchain_publisher.watchdog.transaction.fixed_delay:PT1M}", initialDelayString="${lob.blockchain_publisher.watchdog.transaction.initial_delay:PT1M}")
    public void executeTransactionStatusCheck() {
        log.info("Inspecting all organisations for on chain transaction status changes...");
        this.watchDogService.checkTransactionStatusForOrganisations(this.txStatusInspectionLimitPerOrgPullSize);
    }

    @Scheduled(fixedDelayString="${lob.blockchain_publisher.watchdog.report.fixed_delay:PT1M}", initialDelayString="${lob.blockchain_publisher.watchdog.report.initial_delay:PT1M}")
    public void executeReportStatusCheck() {
        log.info("Inspecting all organisations for on chain report status changes...");
        this.watchDogService.checkReportStatusForOrganisations(this.txStatusInspectionLimitPerOrgPullSize);
    }

    public WatchDogJob(WatchDogService watchDogService) {
        this.watchDogService = watchDogService;
    }
}

