/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs;

import jakarta.persistence.Embeddable;
import java.math.BigDecimal;
import java.util.Objects;

@Embeddable
public class Vat {
    private String customerCode;
    private BigDecimal rate;

    public int hashCode() {
        return Objects.hash(this.customerCode, this.rate);
    }

    public static VatBuilder builder() {
        return new VatBuilder();
    }

    public Vat(String customerCode, BigDecimal rate) {
        this.customerCode = customerCode;
        this.rate = rate;
    }

    public Vat() {
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }

    public static class VatBuilder {
        private String customerCode;
        private BigDecimal rate;

        VatBuilder() {
        }

        public VatBuilder customerCode(String customerCode) {
            this.customerCode = customerCode;
            return this;
        }

        public VatBuilder rate(BigDecimal rate) {
            this.rate = rate;
            return this;
        }

        public Vat build() {
            return new Vat(this.customerCode, this.rate);
        }

        public String toString() {
            return "Vat.VatBuilder(customerCode=" + this.customerCode + ", rate=" + String.valueOf(this.rate) + ")";
        }
    }
}

