/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs;

import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.AccountEvent;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.CostCenter;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Document;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Project;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.TransactionEntity;
import org.cardanofoundation.lob.app.support.spring_audit.CommonDateOnlyEntity;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity(name="blockchain_publisher.TransactionItemEntity")
@Table(name="blockchain_publisher_transaction_item")
@EntityListeners(value={AuditingEntityListener.class})
public class TransactionItemEntity
extends CommonDateOnlyEntity
implements Persistable<String> {
    @Id
    @Column(name="transaction_item_id", nullable=false)
    private String id;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="transaction_id")
    private TransactionEntity transaction;
    @Column(name="amount_fcy", nullable=false)
    private BigDecimal amountFcy;
    @Nullable
    @AttributeOverrides(value={@AttributeOverride(name="code", column=@Column(name="account_event_code", nullable=false)), @AttributeOverride(name="name", column=@Column(name="account_event_name", nullable=false))})
    private AccountEvent accountEvent;
    @Column(name="fx_rate", nullable=false)
    private BigDecimal fxRate;
    @Nullable
    @AttributeOverrides(value={@AttributeOverride(name="customerCode", column=@Column(name="project_customer_code")), @AttributeOverride(name="name", column=@Column(name="project_name"))})
    private Project project;
    @Embedded
    @Nullable
    @AttributeOverrides(value={@AttributeOverride(name="customerCode", column=@Column(name="cost_center_customer_code")), @AttributeOverride(name="name", column=@Column(name="cost_center_name"))})
    private CostCenter costCenter;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="num", column=@Column(name="document_num", nullable=false)), @AttributeOverride(name="vat.customerCode", column=@Column(name="document_vat_customer_code")), @AttributeOverride(name="vat.rate", column=@Column(name="document_vat_rate")), @AttributeOverride(name="currency.id", column=@Column(name="document_currency_id")), @AttributeOverride(name="currency.customerCode", column=@Column(name="document_currency_customer_code", nullable=false)), @AttributeOverride(name="counterparty.customerCode", column=@Column(name="document_counterparty_customer_code")), @AttributeOverride(name="counterparty.type", column=@Column(name="document_counterparty_type"))})
    @Nullable
    private Document document;

    public Optional<AccountEvent> getAccountEvent() {
        return Optional.ofNullable(this.accountEvent);
    }

    public Optional<Project> getProject() {
        return Optional.ofNullable(this.project);
    }

    public Optional<CostCenter> getCostCenter() {
        return Optional.ofNullable(this.costCenter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TransactionItemEntity that = (TransactionItemEntity)((Object)o);
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public int aggregatedHash() {
        return Objects.hash(this.accountEvent, this.fxRate, this.project, this.costCenter, this.document);
    }

    public String getId() {
        return this.id;
    }

    public TransactionEntity getTransaction() {
        return this.transaction;
    }

    public BigDecimal getAmountFcy() {
        return this.amountFcy;
    }

    public BigDecimal getFxRate() {
        return this.fxRate;
    }

    @Nullable
    public Document getDocument() {
        return this.document;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTransaction(TransactionEntity transaction) {
        this.transaction = transaction;
    }

    public void setAmountFcy(BigDecimal amountFcy) {
        this.amountFcy = amountFcy;
    }

    public void setAccountEvent(@Nullable AccountEvent accountEvent) {
        this.accountEvent = accountEvent;
    }

    public void setFxRate(BigDecimal fxRate) {
        this.fxRate = fxRate;
    }

    public void setProject(@Nullable Project project) {
        this.project = project;
    }

    public void setCostCenter(@Nullable CostCenter costCenter) {
        this.costCenter = costCenter;
    }

    public void setDocument(@Nullable Document document) {
        this.document = document;
    }

    public TransactionItemEntity() {
    }

    public TransactionItemEntity(String id, TransactionEntity transaction, BigDecimal amountFcy, @Nullable AccountEvent accountEvent, BigDecimal fxRate, @Nullable Project project, @Nullable CostCenter costCenter, @Nullable Document document) {
        this.id = id;
        this.transaction = transaction;
        this.amountFcy = amountFcy;
        this.accountEvent = accountEvent;
        this.fxRate = fxRate;
        this.project = project;
        this.costCenter = costCenter;
        this.document = document;
    }
}

