/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.reports;

import io.vavr.control.Either;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.Optional;
import javax.annotation.Nullable;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.report.IntervalType;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.report.ReportMode;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.report.ReportType;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.reports.BalanceSheetData;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.reports.IncomeStatementData;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.L1SubmissionData;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Organisation;
import org.cardanofoundation.lob.app.support.spring_audit.CommonDateOnlyEntity;
import org.hibernate.annotations.JdbcType;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity(name="blockchain_publisher.report.ReportEntity")
@Table(name="blockchain_publisher_report")
@EntityListeners(value={AuditingEntityListener.class})
public class ReportEntity
extends CommonDateOnlyEntity
implements Persistable<String> {
    @Id
    @Column(name="report_id", nullable=false, length=64)
    @NotBlank
    private String reportId;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="organisation_id")), @AttributeOverride(name="name", column=@Column(name="organisation_name")), @AttributeOverride(name="countryCode", column=@Column(name="organisation_country_code")), @AttributeOverride(name="taxIdNumber", column=@Column(name="organisation_tax_id_number")), @AttributeOverride(name="currencyId", column=@Column(name="organisation_currency_id"))})
    private Organisation organisation;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type", nullable=false)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    @NotNull
    private ReportType type;
    @Enumerated(value=EnumType.STRING)
    @Column(name="interval_type", nullable=false)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    @NotNull
    private IntervalType intervalType;
    @Column(name="year", nullable=false)
    @Min(value=1900L)
    @Max(value=4000L)
    private @Min(value=1900L) @Max(value=4000L) Short year;
    @Column(name="period")
    @Min(value=1L)
    @Max(value=12L)
    @Nullable
    private @Min(value=1L) @Max(value=12L) Short period;
    @Enumerated(value=EnumType.STRING)
    @Column(name="mode", nullable=false)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private ReportMode mode;
    @Column(name="date", nullable=false)
    @NotNull
    private LocalDate date;
    @Column(name="ver", nullable=false)
    @NotNull
    private long ver;
    @Nullable
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="transactionHash", column=@Column(name="l1_transaction_hash", length=64)), @AttributeOverride(name="absoluteSlot", column=@Column(name="l1_absolute_slot")), @AttributeOverride(name="creationSlot", column=@Column(name="l1_creation_slot")), @AttributeOverride(name="finalityScore", column=@Column(name="l1_finality_score", columnDefinition="blockchain_publisher_finality_score_type")), @AttributeOverride(name="publishStatus", column=@Column(name="l1_publish_status", columnDefinition="blockchain_publisher_blockchain_publish_status_type"))})
    private L1SubmissionData l1SubmissionData;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="assets.nonCurrentAssets.tangibleAssets", column=@Column(name="data_balance_sheet__assets_non_current_tangible_assets")), @AttributeOverride(name="assets.nonCurrentAssets.intangibleAssets", column=@Column(name="data_balance_sheet__assets_non_current_intangible_assets")), @AttributeOverride(name="assets.nonCurrentAssets.investments", column=@Column(name="data_balance_sheet__assets_non_current_investments")), @AttributeOverride(name="assets.nonCurrentAssets.financialAssets", column=@Column(name="data_balance_sheet__assets_non_current_financial_assets")), @AttributeOverride(name="assets.currentAssets.prepaymentsAndOtherShortTermAssets", column=@Column(name="data_balance_sheet__assets_current_prepayments_short_assets")), @AttributeOverride(name="assets.currentAssets.otherReceivables", column=@Column(name="data_balance_sheet__assets_current_other_receivables")), @AttributeOverride(name="assets.currentAssets.cryptoAssets", column=@Column(name="data_balance_sheet__assets_current_crypto_assets")), @AttributeOverride(name="assets.currentAssets.cashAndCashEquivalents", column=@Column(name="data_balance_sheet__assets_current_cash_and_equivalen")), @AttributeOverride(name="liabilities.nonCurrentLiabilities.provisions", column=@Column(name="data_balance_sheet__liabilities_non_current_provisions")), @AttributeOverride(name="liabilities.currentLiabilities.tradeAccountsPayables", column=@Column(name="data_balance_sheet__liabilities_current_trade_accounts")), @AttributeOverride(name="liabilities.currentLiabilities.otherShortTermLiabilities", column=@Column(name="data_balance_sheet__liabilities_current_other_liabilities")), @AttributeOverride(name="liabilities.currentLiabilities.accrualsAndShortTermProvisions", column=@Column(name="data_balance_sheet__liabilities_current_accruals_and_short")), @AttributeOverride(name="capital.capital", column=@Column(name="data_balance_sheet__capital_capital")), @AttributeOverride(name="capital.profitForTheYear", column=@Column(name="data_balance_sheet__capital_profit_for_the_year")), @AttributeOverride(name="capital.resultsCarriedForward", column=@Column(name="data_balance_sheet__capital_results_carried_forward"))})
    @Nullable
    private BalanceSheetData balanceSheetReportData;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="revenues.otherIncome", column=@Column(name="data_income_statement__revenues_other_income")), @AttributeOverride(name="revenues.buildOfLongTermProvision", column=@Column(name="data_income_statement__revenues_build_long_term_provision")), @AttributeOverride(name="costOfGoodsAndServices.externalServices", column=@Column(name="data_income_statement__cost_goods_and_services_external_serv")), @AttributeOverride(name="operatingExpenses.personnelExpenses", column=@Column(name="data_income_statement__operating_expenses_personnel_expenses")), @AttributeOverride(name="operatingExpenses.generalAndAdministrativeExpenses", column=@Column(name="data_income_statement__operating_expenses_general_admin_ex")), @AttributeOverride(name="operatingExpenses.depreciationAndImpairmentLossesOnTangibleAssets", column=@Column(name="data_income_statement__operating_expenses_depreciation_tang")), @AttributeOverride(name="operatingExpenses.amortizationOnIntangibleAssets", column=@Column(name="data_income_statement__operating_expenses_amortization_int")), @AttributeOverride(name="operatingExpenses.rentExpenses", column=@Column(name="data_income_statement__operating_expenses_rent_expenses")), @AttributeOverride(name="financialIncome.financialRevenues", column=@Column(name="data_income_statement__financial_income_financial_revenues")), @AttributeOverride(name="financialIncome.financialExpenses", column=@Column(name="data_income_statement__financial_income_financial_expenses")), @AttributeOverride(name="financialIncome.realisedGainsOnSaleOfCryptocurrencies", column=@Column(name="data_income_statement__financial_income_realised_gains")), @AttributeOverride(name="financialIncome.stakingRewardsIncome", column=@Column(name="data_income_statement__financial_income_staking_rewards")), @AttributeOverride(name="financialIncome.netIncomeOptionsSale", column=@Column(name="data_income_statement__financial_income_net_income_opt")), @AttributeOverride(name="extraordinaryIncome.extraordinaryExpenses", column=@Column(name="data_income_statement__operating_expenses_extraordin_exp")), @AttributeOverride(name="taxExpenses.directTaxes", column=@Column(name="data_income_statement__tax_expenses_direct_taxes")), @AttributeOverride(name="extraordinaryIncome.extraordinaryExpenses", column=@Column(name="data_income_statement__operating_expenses_extraordin_exp")), @AttributeOverride(name="profitForTheYear", column=@Column(name="data_income_statement__profit_for_the_year"))})
    @Nullable
    private IncomeStatementData incomeStatementReportData;

    public String getId() {
        return this.reportId;
    }

    public Optional<L1SubmissionData> getL1SubmissionData() {
        return Optional.ofNullable(this.l1SubmissionData);
    }

    public void setL1SubmissionData(Optional<L1SubmissionData> l1SubmissionData) {
        this.l1SubmissionData = l1SubmissionData.orElse(null);
    }

    public void setData(Either<BalanceSheetData, IncomeStatementData> dataE) {
        if (dataE.isLeft()) {
            this.setBalanceSheetReportData(Optional.of((BalanceSheetData)dataE.getLeft()));
            return;
        }
        if (dataE.isRight()) {
            this.setIncomeStatementReportData(Optional.of((IncomeStatementData)dataE.get()));
            return;
        }
    }

    public void setBalanceSheetReportData(Optional<BalanceSheetData> balanceSheetReportData) {
        if (this.type != ReportType.BALANCE_SHEET) {
            throw new IllegalStateException("Report type is not BALANCE_SHEET!");
        }
        this.balanceSheetReportData = balanceSheetReportData.orElse(null);
    }

    public void setIncomeStatementReportData(Optional<IncomeStatementData> incomeStatementReportData) {
        if (this.type != ReportType.INCOME_STATEMENT) {
            throw new IllegalStateException("Report type is not INCOME_STATEMENT!");
        }
        this.incomeStatementReportData = incomeStatementReportData.orElse(null);
    }

    public Optional<BalanceSheetData> getBalanceSheetReportData() {
        return Optional.ofNullable(this.balanceSheetReportData);
    }

    public Optional<IncomeStatementData> getIncomeStatementReportData() {
        return Optional.ofNullable(this.incomeStatementReportData);
    }

    public Optional<@Min(value=1L) @Max(value=12L) Short> getPeriod() {
        return Optional.ofNullable(this.period);
    }

    public void setPeriod(Optional<@Min(value=1L) @Max(value=12L) Short> period) {
        this.period = period.orElse(null);
    }

    public static ReportEntityBuilder builder() {
        return new ReportEntityBuilder();
    }

    public ReportEntity() {
    }

    public ReportEntity(String reportId, Organisation organisation, ReportType type, IntervalType intervalType, Short year, @Nullable Short period, ReportMode mode, LocalDate date, long ver, @Nullable L1SubmissionData l1SubmissionData, @Nullable BalanceSheetData balanceSheetReportData, @Nullable IncomeStatementData incomeStatementReportData) {
        this.reportId = reportId;
        this.organisation = organisation;
        this.type = type;
        this.intervalType = intervalType;
        this.year = year;
        this.period = period;
        this.mode = mode;
        this.date = date;
        this.ver = ver;
        this.l1SubmissionData = l1SubmissionData;
        this.balanceSheetReportData = balanceSheetReportData;
        this.incomeStatementReportData = incomeStatementReportData;
    }

    public String getReportId() {
        return this.reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public Organisation getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(Organisation organisation) {
        this.organisation = organisation;
    }

    public ReportType getType() {
        return this.type;
    }

    public void setType(ReportType type) {
        this.type = type;
    }

    public IntervalType getIntervalType() {
        return this.intervalType;
    }

    public void setIntervalType(IntervalType intervalType) {
        this.intervalType = intervalType;
    }

    public Short getYear() {
        return this.year;
    }

    public void setYear(Short year) {
        this.year = year;
    }

    public ReportMode getMode() {
        return this.mode;
    }

    public void setMode(ReportMode mode) {
        this.mode = mode;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public long getVer() {
        return this.ver;
    }

    public void setVer(long ver) {
        this.ver = ver;
    }

    public static class ReportEntityBuilder {
        private String reportId;
        private Organisation organisation;
        private ReportType type;
        private IntervalType intervalType;
        private Short year;
        private Short period;
        private ReportMode mode;
        private LocalDate date;
        private long ver;
        private L1SubmissionData l1SubmissionData;
        private BalanceSheetData balanceSheetReportData;
        private IncomeStatementData incomeStatementReportData;

        ReportEntityBuilder() {
        }

        public ReportEntityBuilder reportId(String reportId) {
            this.reportId = reportId;
            return this;
        }

        public ReportEntityBuilder organisation(Organisation organisation) {
            this.organisation = organisation;
            return this;
        }

        public ReportEntityBuilder type(ReportType type) {
            this.type = type;
            return this;
        }

        public ReportEntityBuilder intervalType(IntervalType intervalType) {
            this.intervalType = intervalType;
            return this;
        }

        public ReportEntityBuilder year(Short year) {
            this.year = year;
            return this;
        }

        public ReportEntityBuilder period(@Nullable Short period) {
            this.period = period;
            return this;
        }

        public ReportEntityBuilder mode(ReportMode mode) {
            this.mode = mode;
            return this;
        }

        public ReportEntityBuilder date(LocalDate date) {
            this.date = date;
            return this;
        }

        public ReportEntityBuilder ver(long ver) {
            this.ver = ver;
            return this;
        }

        public ReportEntityBuilder l1SubmissionData(@Nullable L1SubmissionData l1SubmissionData) {
            this.l1SubmissionData = l1SubmissionData;
            return this;
        }

        public ReportEntityBuilder balanceSheetReportData(@Nullable BalanceSheetData balanceSheetReportData) {
            this.balanceSheetReportData = balanceSheetReportData;
            return this;
        }

        public ReportEntityBuilder incomeStatementReportData(@Nullable IncomeStatementData incomeStatementReportData) {
            this.incomeStatementReportData = incomeStatementReportData;
            return this;
        }

        public ReportEntity build() {
            return new ReportEntity(this.reportId, this.organisation, this.type, this.intervalType, this.year, this.period, this.mode, this.date, this.ver, this.l1SubmissionData, this.balanceSheetReportData, this.incomeStatementReportData);
        }

        public String toString() {
            return "ReportEntity.ReportEntityBuilder(reportId=" + this.reportId + ", organisation=" + String.valueOf(this.organisation) + ", type=" + String.valueOf(this.type) + ", intervalType=" + String.valueOf(this.intervalType) + ", year=" + this.year + ", period=" + this.period + ", mode=" + String.valueOf(this.mode) + ", date=" + String.valueOf(this.date) + ", ver=" + this.ver + ", l1SubmissionData=" + String.valueOf(this.l1SubmissionData) + ", balanceSheetReportData=" + String.valueOf(this.balanceSheetReportData) + ", incomeStatementReportData=" + String.valueOf(this.incomeStatementReportData) + ")";
        }
    }
}

