/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.reports;

import jakarta.persistence.Embeddable;
import java.math.BigDecimal;
import java.util.Optional;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.Validable;
import org.cardanofoundation.lob.app.support.calc.BigDecimals;
import org.cardanofoundation.lob.app.support.calc.Summable;

@Embeddable
public class IncomeStatementData
implements Validable,
Summable {
    private Revenues revenues;
    private CostOfGoodsAndServices costOfGoodsAndServices;
    private OperatingExpenses operatingExpenses;
    private FinancialIncome financialIncome;
    private ExtraordinaryIncome extraordinaryIncome;
    private TaxExpenses taxExpenses;
    private BigDecimal profitForTheYear;

    public boolean isValid() {
        return true;
    }

    public Optional<Revenues> getRevenues() {
        return Optional.ofNullable(this.revenues);
    }

    public Optional<CostOfGoodsAndServices> getCostOfGoodsAndServices() {
        return Optional.ofNullable(this.costOfGoodsAndServices);
    }

    public Optional<OperatingExpenses> getOperatingExpenses() {
        return Optional.ofNullable(this.operatingExpenses);
    }

    public Optional<FinancialIncome> getFinancialIncome() {
        return Optional.ofNullable(this.financialIncome);
    }

    public Optional<TaxExpenses> getTaxExpenses() {
        return Optional.ofNullable(this.taxExpenses);
    }

    public Optional<ExtraordinaryIncome> getExtraordinaryIncome() {
        return Optional.ofNullable(this.extraordinaryIncome);
    }

    public Optional<BigDecimal> getProfitForTheYear() {
        return Optional.of(this.sumOf());
    }

    public BigDecimal sumOf() {
        return BigDecimals.sum((Summable[])new Summable[]{this.revenues, this.costOfGoodsAndServices, this.operatingExpenses, this.financialIncome, this.extraordinaryIncome, this.taxExpenses});
    }

    public static IncomeStatementDataBuilder builder() {
        return new IncomeStatementDataBuilder();
    }

    public IncomeStatementDataBuilder toBuilder() {
        return new IncomeStatementDataBuilder().revenues(this.revenues).costOfGoodsAndServices(this.costOfGoodsAndServices).operatingExpenses(this.operatingExpenses).financialIncome(this.financialIncome).extraordinaryIncome(this.extraordinaryIncome).taxExpenses(this.taxExpenses).profitForTheYear(this.profitForTheYear);
    }

    public IncomeStatementData(Revenues revenues, CostOfGoodsAndServices costOfGoodsAndServices, OperatingExpenses operatingExpenses, FinancialIncome financialIncome, ExtraordinaryIncome extraordinaryIncome, TaxExpenses taxExpenses, BigDecimal profitForTheYear) {
        this.revenues = revenues;
        this.costOfGoodsAndServices = costOfGoodsAndServices;
        this.operatingExpenses = operatingExpenses;
        this.financialIncome = financialIncome;
        this.extraordinaryIncome = extraordinaryIncome;
        this.taxExpenses = taxExpenses;
        this.profitForTheYear = profitForTheYear;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IncomeStatementData)) {
            return false;
        }
        IncomeStatementData other = (IncomeStatementData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<Revenues> this$revenues = this.getRevenues();
        Optional<Revenues> other$revenues = other.getRevenues();
        if (this$revenues == null ? other$revenues != null : !((Object)this$revenues).equals(other$revenues)) {
            return false;
        }
        Optional<CostOfGoodsAndServices> this$costOfGoodsAndServices = this.getCostOfGoodsAndServices();
        Optional<CostOfGoodsAndServices> other$costOfGoodsAndServices = other.getCostOfGoodsAndServices();
        if (this$costOfGoodsAndServices == null ? other$costOfGoodsAndServices != null : !((Object)this$costOfGoodsAndServices).equals(other$costOfGoodsAndServices)) {
            return false;
        }
        Optional<OperatingExpenses> this$operatingExpenses = this.getOperatingExpenses();
        Optional<OperatingExpenses> other$operatingExpenses = other.getOperatingExpenses();
        if (this$operatingExpenses == null ? other$operatingExpenses != null : !((Object)this$operatingExpenses).equals(other$operatingExpenses)) {
            return false;
        }
        Optional<FinancialIncome> this$financialIncome = this.getFinancialIncome();
        Optional<FinancialIncome> other$financialIncome = other.getFinancialIncome();
        if (this$financialIncome == null ? other$financialIncome != null : !((Object)this$financialIncome).equals(other$financialIncome)) {
            return false;
        }
        Optional<ExtraordinaryIncome> this$extraordinaryIncome = this.getExtraordinaryIncome();
        Optional<ExtraordinaryIncome> other$extraordinaryIncome = other.getExtraordinaryIncome();
        if (this$extraordinaryIncome == null ? other$extraordinaryIncome != null : !((Object)this$extraordinaryIncome).equals(other$extraordinaryIncome)) {
            return false;
        }
        Optional<TaxExpenses> this$taxExpenses = this.getTaxExpenses();
        Optional<TaxExpenses> other$taxExpenses = other.getTaxExpenses();
        if (this$taxExpenses == null ? other$taxExpenses != null : !((Object)this$taxExpenses).equals(other$taxExpenses)) {
            return false;
        }
        Optional<BigDecimal> this$profitForTheYear = this.getProfitForTheYear();
        Optional<BigDecimal> other$profitForTheYear = other.getProfitForTheYear();
        return !(this$profitForTheYear == null ? other$profitForTheYear != null : !((Object)this$profitForTheYear).equals(other$profitForTheYear));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IncomeStatementData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<Revenues> $revenues = this.getRevenues();
        result = result * 59 + ($revenues == null ? 43 : ((Object)$revenues).hashCode());
        Optional<CostOfGoodsAndServices> $costOfGoodsAndServices = this.getCostOfGoodsAndServices();
        result = result * 59 + ($costOfGoodsAndServices == null ? 43 : ((Object)$costOfGoodsAndServices).hashCode());
        Optional<OperatingExpenses> $operatingExpenses = this.getOperatingExpenses();
        result = result * 59 + ($operatingExpenses == null ? 43 : ((Object)$operatingExpenses).hashCode());
        Optional<FinancialIncome> $financialIncome = this.getFinancialIncome();
        result = result * 59 + ($financialIncome == null ? 43 : ((Object)$financialIncome).hashCode());
        Optional<ExtraordinaryIncome> $extraordinaryIncome = this.getExtraordinaryIncome();
        result = result * 59 + ($extraordinaryIncome == null ? 43 : ((Object)$extraordinaryIncome).hashCode());
        Optional<TaxExpenses> $taxExpenses = this.getTaxExpenses();
        result = result * 59 + ($taxExpenses == null ? 43 : ((Object)$taxExpenses).hashCode());
        Optional<BigDecimal> $profitForTheYear = this.getProfitForTheYear();
        result = result * 59 + ($profitForTheYear == null ? 43 : ((Object)$profitForTheYear).hashCode());
        return result;
    }

    public String toString() {
        return "IncomeStatementData(revenues=" + String.valueOf(this.getRevenues()) + ", costOfGoodsAndServices=" + String.valueOf(this.getCostOfGoodsAndServices()) + ", operatingExpenses=" + String.valueOf(this.getOperatingExpenses()) + ", financialIncome=" + String.valueOf(this.getFinancialIncome()) + ", extraordinaryIncome=" + String.valueOf(this.getExtraordinaryIncome()) + ", taxExpenses=" + String.valueOf(this.getTaxExpenses()) + ", profitForTheYear=" + String.valueOf(this.getProfitForTheYear()) + ")";
    }

    public IncomeStatementData() {
    }

    @Embeddable
    public static class Revenues
    implements Summable {
        private BigDecimal otherIncome;
        private BigDecimal buildOfLongTermProvision;

        public Optional<BigDecimal> getOtherIncome() {
            return Optional.ofNullable(this.otherIncome);
        }

        public Optional<BigDecimal> getBuildOfLongTermProvision() {
            return Optional.ofNullable(this.buildOfLongTermProvision);
        }

        public BigDecimal sumOf() {
            return BigDecimals.sum((BigDecimal[])new BigDecimal[]{this.otherIncome, this.buildOfLongTermProvision});
        }

        public static RevenuesBuilder builder() {
            return new RevenuesBuilder();
        }

        public RevenuesBuilder toBuilder() {
            return new RevenuesBuilder().otherIncome(this.otherIncome).buildOfLongTermProvision(this.buildOfLongTermProvision);
        }

        public Revenues(BigDecimal otherIncome, BigDecimal buildOfLongTermProvision) {
            this.otherIncome = otherIncome;
            this.buildOfLongTermProvision = buildOfLongTermProvision;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Revenues)) {
                return false;
            }
            Revenues other = (Revenues)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<BigDecimal> this$otherIncome = this.getOtherIncome();
            Optional<BigDecimal> other$otherIncome = other.getOtherIncome();
            if (this$otherIncome == null ? other$otherIncome != null : !((Object)this$otherIncome).equals(other$otherIncome)) {
                return false;
            }
            Optional<BigDecimal> this$buildOfLongTermProvision = this.getBuildOfLongTermProvision();
            Optional<BigDecimal> other$buildOfLongTermProvision = other.getBuildOfLongTermProvision();
            return !(this$buildOfLongTermProvision == null ? other$buildOfLongTermProvision != null : !((Object)this$buildOfLongTermProvision).equals(other$buildOfLongTermProvision));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Revenues;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<BigDecimal> $otherIncome = this.getOtherIncome();
            result = result * 59 + ($otherIncome == null ? 43 : ((Object)$otherIncome).hashCode());
            Optional<BigDecimal> $buildOfLongTermProvision = this.getBuildOfLongTermProvision();
            result = result * 59 + ($buildOfLongTermProvision == null ? 43 : ((Object)$buildOfLongTermProvision).hashCode());
            return result;
        }

        public String toString() {
            return "IncomeStatementData.Revenues(otherIncome=" + String.valueOf(this.getOtherIncome()) + ", buildOfLongTermProvision=" + String.valueOf(this.getBuildOfLongTermProvision()) + ")";
        }

        public Revenues() {
        }

        public static class RevenuesBuilder {
            private BigDecimal otherIncome;
            private BigDecimal buildOfLongTermProvision;

            RevenuesBuilder() {
            }

            public RevenuesBuilder otherIncome(BigDecimal otherIncome) {
                this.otherIncome = otherIncome;
                return this;
            }

            public RevenuesBuilder buildOfLongTermProvision(BigDecimal buildOfLongTermProvision) {
                this.buildOfLongTermProvision = buildOfLongTermProvision;
                return this;
            }

            public Revenues build() {
                return new Revenues(this.otherIncome, this.buildOfLongTermProvision);
            }

            public String toString() {
                return "IncomeStatementData.Revenues.RevenuesBuilder(otherIncome=" + String.valueOf(this.otherIncome) + ", buildOfLongTermProvision=" + String.valueOf(this.buildOfLongTermProvision) + ")";
            }
        }
    }

    @Embeddable
    public static class CostOfGoodsAndServices
    implements Summable {
        private BigDecimal externalServices;

        public Optional<BigDecimal> getExternalServices() {
            return Optional.ofNullable(this.externalServices);
        }

        public BigDecimal sumOf() {
            return BigDecimals.sum((BigDecimal[])new BigDecimal[]{this.externalServices});
        }

        public static CostOfGoodsAndServicesBuilder builder() {
            return new CostOfGoodsAndServicesBuilder();
        }

        public CostOfGoodsAndServicesBuilder toBuilder() {
            return new CostOfGoodsAndServicesBuilder().externalServices(this.externalServices);
        }

        public CostOfGoodsAndServices(BigDecimal externalServices) {
            this.externalServices = externalServices;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CostOfGoodsAndServices)) {
                return false;
            }
            CostOfGoodsAndServices other = (CostOfGoodsAndServices)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<BigDecimal> this$externalServices = this.getExternalServices();
            Optional<BigDecimal> other$externalServices = other.getExternalServices();
            return !(this$externalServices == null ? other$externalServices != null : !((Object)this$externalServices).equals(other$externalServices));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CostOfGoodsAndServices;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<BigDecimal> $externalServices = this.getExternalServices();
            result = result * 59 + ($externalServices == null ? 43 : ((Object)$externalServices).hashCode());
            return result;
        }

        public String toString() {
            return "IncomeStatementData.CostOfGoodsAndServices(externalServices=" + String.valueOf(this.getExternalServices()) + ")";
        }

        public CostOfGoodsAndServices() {
        }

        public static class CostOfGoodsAndServicesBuilder {
            private BigDecimal externalServices;

            CostOfGoodsAndServicesBuilder() {
            }

            public CostOfGoodsAndServicesBuilder externalServices(BigDecimal externalServices) {
                this.externalServices = externalServices;
                return this;
            }

            public CostOfGoodsAndServices build() {
                return new CostOfGoodsAndServices(this.externalServices);
            }

            public String toString() {
                return "IncomeStatementData.CostOfGoodsAndServices.CostOfGoodsAndServicesBuilder(externalServices=" + String.valueOf(this.externalServices) + ")";
            }
        }
    }

    @Embeddable
    public static class OperatingExpenses
    implements Summable {
        private BigDecimal personnelExpenses;
        private BigDecimal generalAndAdministrativeExpenses;
        private BigDecimal depreciationAndImpairmentLossesOnTangibleAssets;
        private BigDecimal amortizationOnIntangibleAssets;
        private BigDecimal rentExpenses;

        public Optional<BigDecimal> getPersonnelExpenses() {
            return Optional.ofNullable(this.personnelExpenses);
        }

        public Optional<BigDecimal> getGeneralAndAdministrativeExpenses() {
            return Optional.ofNullable(this.generalAndAdministrativeExpenses);
        }

        public Optional<BigDecimal> getDepreciationAndImpairmentLossesOnTangibleAssets() {
            return Optional.ofNullable(this.depreciationAndImpairmentLossesOnTangibleAssets);
        }

        public Optional<BigDecimal> getAmortizationOnIntangibleAssets() {
            return Optional.ofNullable(this.amortizationOnIntangibleAssets);
        }

        public Optional<BigDecimal> getRentExpenses() {
            return Optional.ofNullable(this.rentExpenses);
        }

        public BigDecimal sumOf() {
            return BigDecimals.sum((BigDecimal[])new BigDecimal[]{this.personnelExpenses, this.generalAndAdministrativeExpenses, this.depreciationAndImpairmentLossesOnTangibleAssets, this.amortizationOnIntangibleAssets, this.rentExpenses});
        }

        public static OperatingExpensesBuilder builder() {
            return new OperatingExpensesBuilder();
        }

        public OperatingExpensesBuilder toBuilder() {
            return new OperatingExpensesBuilder().personnelExpenses(this.personnelExpenses).generalAndAdministrativeExpenses(this.generalAndAdministrativeExpenses).depreciationAndImpairmentLossesOnTangibleAssets(this.depreciationAndImpairmentLossesOnTangibleAssets).amortizationOnIntangibleAssets(this.amortizationOnIntangibleAssets).rentExpenses(this.rentExpenses);
        }

        public OperatingExpenses(BigDecimal personnelExpenses, BigDecimal generalAndAdministrativeExpenses, BigDecimal depreciationAndImpairmentLossesOnTangibleAssets, BigDecimal amortizationOnIntangibleAssets, BigDecimal rentExpenses) {
            this.personnelExpenses = personnelExpenses;
            this.generalAndAdministrativeExpenses = generalAndAdministrativeExpenses;
            this.depreciationAndImpairmentLossesOnTangibleAssets = depreciationAndImpairmentLossesOnTangibleAssets;
            this.amortizationOnIntangibleAssets = amortizationOnIntangibleAssets;
            this.rentExpenses = rentExpenses;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperatingExpenses)) {
                return false;
            }
            OperatingExpenses other = (OperatingExpenses)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<BigDecimal> this$personnelExpenses = this.getPersonnelExpenses();
            Optional<BigDecimal> other$personnelExpenses = other.getPersonnelExpenses();
            if (this$personnelExpenses == null ? other$personnelExpenses != null : !((Object)this$personnelExpenses).equals(other$personnelExpenses)) {
                return false;
            }
            Optional<BigDecimal> this$generalAndAdministrativeExpenses = this.getGeneralAndAdministrativeExpenses();
            Optional<BigDecimal> other$generalAndAdministrativeExpenses = other.getGeneralAndAdministrativeExpenses();
            if (this$generalAndAdministrativeExpenses == null ? other$generalAndAdministrativeExpenses != null : !((Object)this$generalAndAdministrativeExpenses).equals(other$generalAndAdministrativeExpenses)) {
                return false;
            }
            Optional<BigDecimal> this$depreciationAndImpairmentLossesOnTangibleAssets = this.getDepreciationAndImpairmentLossesOnTangibleAssets();
            Optional<BigDecimal> other$depreciationAndImpairmentLossesOnTangibleAssets = other.getDepreciationAndImpairmentLossesOnTangibleAssets();
            if (this$depreciationAndImpairmentLossesOnTangibleAssets == null ? other$depreciationAndImpairmentLossesOnTangibleAssets != null : !((Object)this$depreciationAndImpairmentLossesOnTangibleAssets).equals(other$depreciationAndImpairmentLossesOnTangibleAssets)) {
                return false;
            }
            Optional<BigDecimal> this$amortizationOnIntangibleAssets = this.getAmortizationOnIntangibleAssets();
            Optional<BigDecimal> other$amortizationOnIntangibleAssets = other.getAmortizationOnIntangibleAssets();
            if (this$amortizationOnIntangibleAssets == null ? other$amortizationOnIntangibleAssets != null : !((Object)this$amortizationOnIntangibleAssets).equals(other$amortizationOnIntangibleAssets)) {
                return false;
            }
            Optional<BigDecimal> this$rentExpenses = this.getRentExpenses();
            Optional<BigDecimal> other$rentExpenses = other.getRentExpenses();
            return !(this$rentExpenses == null ? other$rentExpenses != null : !((Object)this$rentExpenses).equals(other$rentExpenses));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OperatingExpenses;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<BigDecimal> $personnelExpenses = this.getPersonnelExpenses();
            result = result * 59 + ($personnelExpenses == null ? 43 : ((Object)$personnelExpenses).hashCode());
            Optional<BigDecimal> $generalAndAdministrativeExpenses = this.getGeneralAndAdministrativeExpenses();
            result = result * 59 + ($generalAndAdministrativeExpenses == null ? 43 : ((Object)$generalAndAdministrativeExpenses).hashCode());
            Optional<BigDecimal> $depreciationAndImpairmentLossesOnTangibleAssets = this.getDepreciationAndImpairmentLossesOnTangibleAssets();
            result = result * 59 + ($depreciationAndImpairmentLossesOnTangibleAssets == null ? 43 : ((Object)$depreciationAndImpairmentLossesOnTangibleAssets).hashCode());
            Optional<BigDecimal> $amortizationOnIntangibleAssets = this.getAmortizationOnIntangibleAssets();
            result = result * 59 + ($amortizationOnIntangibleAssets == null ? 43 : ((Object)$amortizationOnIntangibleAssets).hashCode());
            Optional<BigDecimal> $rentExpenses = this.getRentExpenses();
            result = result * 59 + ($rentExpenses == null ? 43 : ((Object)$rentExpenses).hashCode());
            return result;
        }

        public String toString() {
            return "IncomeStatementData.OperatingExpenses(personnelExpenses=" + String.valueOf(this.getPersonnelExpenses()) + ", generalAndAdministrativeExpenses=" + String.valueOf(this.getGeneralAndAdministrativeExpenses()) + ", depreciationAndImpairmentLossesOnTangibleAssets=" + String.valueOf(this.getDepreciationAndImpairmentLossesOnTangibleAssets()) + ", amortizationOnIntangibleAssets=" + String.valueOf(this.getAmortizationOnIntangibleAssets()) + ", rentExpenses=" + String.valueOf(this.getRentExpenses()) + ")";
        }

        public OperatingExpenses() {
        }

        public static class OperatingExpensesBuilder {
            private BigDecimal personnelExpenses;
            private BigDecimal generalAndAdministrativeExpenses;
            private BigDecimal depreciationAndImpairmentLossesOnTangibleAssets;
            private BigDecimal amortizationOnIntangibleAssets;
            private BigDecimal rentExpenses;

            OperatingExpensesBuilder() {
            }

            public OperatingExpensesBuilder personnelExpenses(BigDecimal personnelExpenses) {
                this.personnelExpenses = personnelExpenses;
                return this;
            }

            public OperatingExpensesBuilder generalAndAdministrativeExpenses(BigDecimal generalAndAdministrativeExpenses) {
                this.generalAndAdministrativeExpenses = generalAndAdministrativeExpenses;
                return this;
            }

            public OperatingExpensesBuilder depreciationAndImpairmentLossesOnTangibleAssets(BigDecimal depreciationAndImpairmentLossesOnTangibleAssets) {
                this.depreciationAndImpairmentLossesOnTangibleAssets = depreciationAndImpairmentLossesOnTangibleAssets;
                return this;
            }

            public OperatingExpensesBuilder amortizationOnIntangibleAssets(BigDecimal amortizationOnIntangibleAssets) {
                this.amortizationOnIntangibleAssets = amortizationOnIntangibleAssets;
                return this;
            }

            public OperatingExpensesBuilder rentExpenses(BigDecimal rentExpenses) {
                this.rentExpenses = rentExpenses;
                return this;
            }

            public OperatingExpenses build() {
                return new OperatingExpenses(this.personnelExpenses, this.generalAndAdministrativeExpenses, this.depreciationAndImpairmentLossesOnTangibleAssets, this.amortizationOnIntangibleAssets, this.rentExpenses);
            }

            public String toString() {
                return "IncomeStatementData.OperatingExpenses.OperatingExpensesBuilder(personnelExpenses=" + String.valueOf(this.personnelExpenses) + ", generalAndAdministrativeExpenses=" + String.valueOf(this.generalAndAdministrativeExpenses) + ", depreciationAndImpairmentLossesOnTangibleAssets=" + String.valueOf(this.depreciationAndImpairmentLossesOnTangibleAssets) + ", amortizationOnIntangibleAssets=" + String.valueOf(this.amortizationOnIntangibleAssets) + ", rentExpenses=" + String.valueOf(this.rentExpenses) + ")";
            }
        }
    }

    @Embeddable
    public static class FinancialIncome
    implements Summable {
        private BigDecimal financialRevenues;
        private BigDecimal financialExpenses;
        private BigDecimal realisedGainsOnSaleOfCryptocurrencies;
        private BigDecimal stakingRewardsIncome;
        private BigDecimal netIncomeOptionsSale;

        public Optional<BigDecimal> getFinancialRevenues() {
            return Optional.ofNullable(this.financialRevenues);
        }

        public Optional<BigDecimal> getFinancialExpenses() {
            return Optional.ofNullable(this.financialExpenses);
        }

        public Optional<BigDecimal> getRealisedGainsOnSaleOfCryptocurrencies() {
            return Optional.ofNullable(this.realisedGainsOnSaleOfCryptocurrencies);
        }

        public Optional<BigDecimal> getStakingRewardsIncome() {
            return Optional.ofNullable(this.stakingRewardsIncome);
        }

        public Optional<BigDecimal> getNetIncomeOptionsSale() {
            return Optional.ofNullable(this.netIncomeOptionsSale);
        }

        public BigDecimal sumOf() {
            return BigDecimals.sum((BigDecimal[])new BigDecimal[]{this.financialRevenues, this.financialExpenses, this.realisedGainsOnSaleOfCryptocurrencies, this.stakingRewardsIncome, this.netIncomeOptionsSale});
        }

        public static FinancialIncomeBuilder builder() {
            return new FinancialIncomeBuilder();
        }

        public FinancialIncomeBuilder toBuilder() {
            return new FinancialIncomeBuilder().financialRevenues(this.financialRevenues).financialExpenses(this.financialExpenses).realisedGainsOnSaleOfCryptocurrencies(this.realisedGainsOnSaleOfCryptocurrencies).stakingRewardsIncome(this.stakingRewardsIncome).netIncomeOptionsSale(this.netIncomeOptionsSale);
        }

        public FinancialIncome(BigDecimal financialRevenues, BigDecimal financialExpenses, BigDecimal realisedGainsOnSaleOfCryptocurrencies, BigDecimal stakingRewardsIncome, BigDecimal netIncomeOptionsSale) {
            this.financialRevenues = financialRevenues;
            this.financialExpenses = financialExpenses;
            this.realisedGainsOnSaleOfCryptocurrencies = realisedGainsOnSaleOfCryptocurrencies;
            this.stakingRewardsIncome = stakingRewardsIncome;
            this.netIncomeOptionsSale = netIncomeOptionsSale;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FinancialIncome)) {
                return false;
            }
            FinancialIncome other = (FinancialIncome)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<BigDecimal> this$financialRevenues = this.getFinancialRevenues();
            Optional<BigDecimal> other$financialRevenues = other.getFinancialRevenues();
            if (this$financialRevenues == null ? other$financialRevenues != null : !((Object)this$financialRevenues).equals(other$financialRevenues)) {
                return false;
            }
            Optional<BigDecimal> this$financialExpenses = this.getFinancialExpenses();
            Optional<BigDecimal> other$financialExpenses = other.getFinancialExpenses();
            if (this$financialExpenses == null ? other$financialExpenses != null : !((Object)this$financialExpenses).equals(other$financialExpenses)) {
                return false;
            }
            Optional<BigDecimal> this$realisedGainsOnSaleOfCryptocurrencies = this.getRealisedGainsOnSaleOfCryptocurrencies();
            Optional<BigDecimal> other$realisedGainsOnSaleOfCryptocurrencies = other.getRealisedGainsOnSaleOfCryptocurrencies();
            if (this$realisedGainsOnSaleOfCryptocurrencies == null ? other$realisedGainsOnSaleOfCryptocurrencies != null : !((Object)this$realisedGainsOnSaleOfCryptocurrencies).equals(other$realisedGainsOnSaleOfCryptocurrencies)) {
                return false;
            }
            Optional<BigDecimal> this$stakingRewardsIncome = this.getStakingRewardsIncome();
            Optional<BigDecimal> other$stakingRewardsIncome = other.getStakingRewardsIncome();
            if (this$stakingRewardsIncome == null ? other$stakingRewardsIncome != null : !((Object)this$stakingRewardsIncome).equals(other$stakingRewardsIncome)) {
                return false;
            }
            Optional<BigDecimal> this$netIncomeOptionsSale = this.getNetIncomeOptionsSale();
            Optional<BigDecimal> other$netIncomeOptionsSale = other.getNetIncomeOptionsSale();
            return !(this$netIncomeOptionsSale == null ? other$netIncomeOptionsSale != null : !((Object)this$netIncomeOptionsSale).equals(other$netIncomeOptionsSale));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FinancialIncome;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<BigDecimal> $financialRevenues = this.getFinancialRevenues();
            result = result * 59 + ($financialRevenues == null ? 43 : ((Object)$financialRevenues).hashCode());
            Optional<BigDecimal> $financialExpenses = this.getFinancialExpenses();
            result = result * 59 + ($financialExpenses == null ? 43 : ((Object)$financialExpenses).hashCode());
            Optional<BigDecimal> $realisedGainsOnSaleOfCryptocurrencies = this.getRealisedGainsOnSaleOfCryptocurrencies();
            result = result * 59 + ($realisedGainsOnSaleOfCryptocurrencies == null ? 43 : ((Object)$realisedGainsOnSaleOfCryptocurrencies).hashCode());
            Optional<BigDecimal> $stakingRewardsIncome = this.getStakingRewardsIncome();
            result = result * 59 + ($stakingRewardsIncome == null ? 43 : ((Object)$stakingRewardsIncome).hashCode());
            Optional<BigDecimal> $netIncomeOptionsSale = this.getNetIncomeOptionsSale();
            result = result * 59 + ($netIncomeOptionsSale == null ? 43 : ((Object)$netIncomeOptionsSale).hashCode());
            return result;
        }

        public String toString() {
            return "IncomeStatementData.FinancialIncome(financialRevenues=" + String.valueOf(this.getFinancialRevenues()) + ", financialExpenses=" + String.valueOf(this.getFinancialExpenses()) + ", realisedGainsOnSaleOfCryptocurrencies=" + String.valueOf(this.getRealisedGainsOnSaleOfCryptocurrencies()) + ", stakingRewardsIncome=" + String.valueOf(this.getStakingRewardsIncome()) + ", netIncomeOptionsSale=" + String.valueOf(this.getNetIncomeOptionsSale()) + ")";
        }

        public FinancialIncome() {
        }

        public static class FinancialIncomeBuilder {
            private BigDecimal financialRevenues;
            private BigDecimal financialExpenses;
            private BigDecimal realisedGainsOnSaleOfCryptocurrencies;
            private BigDecimal stakingRewardsIncome;
            private BigDecimal netIncomeOptionsSale;

            FinancialIncomeBuilder() {
            }

            public FinancialIncomeBuilder financialRevenues(BigDecimal financialRevenues) {
                this.financialRevenues = financialRevenues;
                return this;
            }

            public FinancialIncomeBuilder financialExpenses(BigDecimal financialExpenses) {
                this.financialExpenses = financialExpenses;
                return this;
            }

            public FinancialIncomeBuilder realisedGainsOnSaleOfCryptocurrencies(BigDecimal realisedGainsOnSaleOfCryptocurrencies) {
                this.realisedGainsOnSaleOfCryptocurrencies = realisedGainsOnSaleOfCryptocurrencies;
                return this;
            }

            public FinancialIncomeBuilder stakingRewardsIncome(BigDecimal stakingRewardsIncome) {
                this.stakingRewardsIncome = stakingRewardsIncome;
                return this;
            }

            public FinancialIncomeBuilder netIncomeOptionsSale(BigDecimal netIncomeOptionsSale) {
                this.netIncomeOptionsSale = netIncomeOptionsSale;
                return this;
            }

            public FinancialIncome build() {
                return new FinancialIncome(this.financialRevenues, this.financialExpenses, this.realisedGainsOnSaleOfCryptocurrencies, this.stakingRewardsIncome, this.netIncomeOptionsSale);
            }

            public String toString() {
                return "IncomeStatementData.FinancialIncome.FinancialIncomeBuilder(financialRevenues=" + String.valueOf(this.financialRevenues) + ", financialExpenses=" + String.valueOf(this.financialExpenses) + ", realisedGainsOnSaleOfCryptocurrencies=" + String.valueOf(this.realisedGainsOnSaleOfCryptocurrencies) + ", stakingRewardsIncome=" + String.valueOf(this.stakingRewardsIncome) + ", netIncomeOptionsSale=" + String.valueOf(this.netIncomeOptionsSale) + ")";
            }
        }
    }

    @Embeddable
    public static class TaxExpenses
    implements Summable {
        private BigDecimal directTaxes;

        public Optional<BigDecimal> getDirectTaxes() {
            return Optional.ofNullable(this.directTaxes);
        }

        public BigDecimal sumOf() {
            return BigDecimals.sum((BigDecimal[])new BigDecimal[]{this.directTaxes});
        }

        public static TaxExpensesBuilder builder() {
            return new TaxExpensesBuilder();
        }

        public TaxExpensesBuilder toBuilder() {
            return new TaxExpensesBuilder().directTaxes(this.directTaxes);
        }

        public TaxExpenses(BigDecimal directTaxes) {
            this.directTaxes = directTaxes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaxExpenses)) {
                return false;
            }
            TaxExpenses other = (TaxExpenses)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<BigDecimal> this$directTaxes = this.getDirectTaxes();
            Optional<BigDecimal> other$directTaxes = other.getDirectTaxes();
            return !(this$directTaxes == null ? other$directTaxes != null : !((Object)this$directTaxes).equals(other$directTaxes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TaxExpenses;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<BigDecimal> $directTaxes = this.getDirectTaxes();
            result = result * 59 + ($directTaxes == null ? 43 : ((Object)$directTaxes).hashCode());
            return result;
        }

        public String toString() {
            return "IncomeStatementData.TaxExpenses(directTaxes=" + String.valueOf(this.getDirectTaxes()) + ")";
        }

        public TaxExpenses() {
        }

        public static class TaxExpensesBuilder {
            private BigDecimal directTaxes;

            TaxExpensesBuilder() {
            }

            public TaxExpensesBuilder directTaxes(BigDecimal directTaxes) {
                this.directTaxes = directTaxes;
                return this;
            }

            public TaxExpenses build() {
                return new TaxExpenses(this.directTaxes);
            }

            public String toString() {
                return "IncomeStatementData.TaxExpenses.TaxExpensesBuilder(directTaxes=" + String.valueOf(this.directTaxes) + ")";
            }
        }
    }

    @Embeddable
    public static class ExtraordinaryIncome
    implements Summable {
        private BigDecimal extraordinaryExpenses;

        public Optional<BigDecimal> getExtraordinaryExpenses() {
            return Optional.ofNullable(this.extraordinaryExpenses);
        }

        public BigDecimal sumOf() {
            return BigDecimals.sum((BigDecimal[])new BigDecimal[]{this.extraordinaryExpenses});
        }

        public static ExtraordinaryIncomeBuilder builder() {
            return new ExtraordinaryIncomeBuilder();
        }

        public ExtraordinaryIncomeBuilder toBuilder() {
            return new ExtraordinaryIncomeBuilder().extraordinaryExpenses(this.extraordinaryExpenses);
        }

        public ExtraordinaryIncome(BigDecimal extraordinaryExpenses) {
            this.extraordinaryExpenses = extraordinaryExpenses;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtraordinaryIncome)) {
                return false;
            }
            ExtraordinaryIncome other = (ExtraordinaryIncome)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<BigDecimal> this$extraordinaryExpenses = this.getExtraordinaryExpenses();
            Optional<BigDecimal> other$extraordinaryExpenses = other.getExtraordinaryExpenses();
            return !(this$extraordinaryExpenses == null ? other$extraordinaryExpenses != null : !((Object)this$extraordinaryExpenses).equals(other$extraordinaryExpenses));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExtraordinaryIncome;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<BigDecimal> $extraordinaryExpenses = this.getExtraordinaryExpenses();
            result = result * 59 + ($extraordinaryExpenses == null ? 43 : ((Object)$extraordinaryExpenses).hashCode());
            return result;
        }

        public String toString() {
            return "IncomeStatementData.ExtraordinaryIncome(extraordinaryExpenses=" + String.valueOf(this.getExtraordinaryExpenses()) + ")";
        }

        public ExtraordinaryIncome() {
        }

        public static class ExtraordinaryIncomeBuilder {
            private BigDecimal extraordinaryExpenses;

            ExtraordinaryIncomeBuilder() {
            }

            public ExtraordinaryIncomeBuilder extraordinaryExpenses(BigDecimal extraordinaryExpenses) {
                this.extraordinaryExpenses = extraordinaryExpenses;
                return this;
            }

            public ExtraordinaryIncome build() {
                return new ExtraordinaryIncome(this.extraordinaryExpenses);
            }

            public String toString() {
                return "IncomeStatementData.ExtraordinaryIncome.ExtraordinaryIncomeBuilder(extraordinaryExpenses=" + String.valueOf(this.extraordinaryExpenses) + ")";
            }
        }
    }

    public static class IncomeStatementDataBuilder {
        private Revenues revenues;
        private CostOfGoodsAndServices costOfGoodsAndServices;
        private OperatingExpenses operatingExpenses;
        private FinancialIncome financialIncome;
        private ExtraordinaryIncome extraordinaryIncome;
        private TaxExpenses taxExpenses;
        private BigDecimal profitForTheYear;

        IncomeStatementDataBuilder() {
        }

        public IncomeStatementDataBuilder revenues(Revenues revenues) {
            this.revenues = revenues;
            return this;
        }

        public IncomeStatementDataBuilder costOfGoodsAndServices(CostOfGoodsAndServices costOfGoodsAndServices) {
            this.costOfGoodsAndServices = costOfGoodsAndServices;
            return this;
        }

        public IncomeStatementDataBuilder operatingExpenses(OperatingExpenses operatingExpenses) {
            this.operatingExpenses = operatingExpenses;
            return this;
        }

        public IncomeStatementDataBuilder financialIncome(FinancialIncome financialIncome) {
            this.financialIncome = financialIncome;
            return this;
        }

        public IncomeStatementDataBuilder extraordinaryIncome(ExtraordinaryIncome extraordinaryIncome) {
            this.extraordinaryIncome = extraordinaryIncome;
            return this;
        }

        public IncomeStatementDataBuilder taxExpenses(TaxExpenses taxExpenses) {
            this.taxExpenses = taxExpenses;
            return this;
        }

        public IncomeStatementDataBuilder profitForTheYear(BigDecimal profitForTheYear) {
            this.profitForTheYear = profitForTheYear;
            return this;
        }

        public IncomeStatementData build() {
            return new IncomeStatementData(this.revenues, this.costOfGoodsAndServices, this.operatingExpenses, this.financialIncome, this.extraordinaryIncome, this.taxExpenses, this.profitForTheYear);
        }

        public String toString() {
            return "IncomeStatementData.IncomeStatementDataBuilder(revenues=" + String.valueOf(this.revenues) + ", costOfGoodsAndServices=" + String.valueOf(this.costOfGoodsAndServices) + ", operatingExpenses=" + String.valueOf(this.operatingExpenses) + ", financialIncome=" + String.valueOf(this.financialIncome) + ", extraordinaryIncome=" + String.valueOf(this.extraordinaryIncome) + ", taxExpenses=" + String.valueOf(this.taxExpenses) + ", profitForTheYear=" + String.valueOf(this.profitForTheYear) + ")";
        }
    }
}

