/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.config;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.common.model.Networks;
import org.cardanofoundation.lob.app.blockchain_common.domain.CardanoNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="blockchain_publisher.cardano_client_lib")
public class CardanoClientLibConfig {
    private static final Logger log = LoggerFactory.getLogger(CardanoClientLibConfig.class);

    @Bean
    @Qualifier(value="lob_owner_account")
    public Account ownerAccount(CardanoNetwork cardanoNetwork, @Value(value="${lob_owner_account_mnemonic:test test test test test test test test test test test test test test test test test test test test test test test sauce}") String lobOwnerMnemonics) {
        Account organiserAccount = switch (cardanoNetwork) {
            default -> throw new MatchException(null, null);
            case CardanoNetwork.MAIN -> new Account(Networks.mainnet(), lobOwnerMnemonics);
            case CardanoNetwork.PREPROD -> new Account(Networks.preprod(), lobOwnerMnemonics);
            case CardanoNetwork.PREVIEW -> new Account(Networks.preview(), lobOwnerMnemonics);
            case CardanoNetwork.DEV -> new Account(Networks.testnet(), lobOwnerMnemonics);
        };
        log.info("LOB's address:{}, stakeAddress:{}", (Object)organiserAccount.baseAddress(), (Object)organiserAccount.stakeAddress());
        return organiserAccount;
    }
}

