/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.service.dispatch;

import com.bloxbean.cardano.client.api.exception.ApiException;
import io.vavr.control.Either;
import java.util.Optional;
import java.util.Set;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.API3BlockchainTransaction;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.BlockchainPublishStatus;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.L1Submission;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.reports.ReportEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.L1SubmissionData;
import org.cardanofoundation.lob.app.blockchain_publisher.repository.ReportEntityRepositoryGateway;
import org.cardanofoundation.lob.app.blockchain_publisher.service.API3L1TransactionCreator;
import org.cardanofoundation.lob.app.blockchain_publisher.service.dispatch.DispatchingStrategy;
import org.cardanofoundation.lob.app.blockchain_publisher.service.dispatch.ImmediateDispatchingStrategy;
import org.cardanofoundation.lob.app.blockchain_publisher.service.event_publish.LedgerUpdatedEventPublisher;
import org.cardanofoundation.lob.app.blockchain_publisher.service.transation_submit.TransactionSubmissionService;
import org.cardanofoundation.lob.app.organisation.OrganisationPublicApi;
import org.cardanofoundation.lob.app.organisation.domain.entity.Organisation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.zalando.problem.Problem;

@Service
public class BlockchainReportsDispatcher {
    private static final Logger log = LoggerFactory.getLogger(BlockchainReportsDispatcher.class);
    private final OrganisationPublicApi organisationPublicApi;
    private final ReportEntityRepositoryGateway reportEntityRepositoryGateway;
    private final DispatchingStrategy<ReportEntity> dispatchingStrategy = new ImmediateDispatchingStrategy<ReportEntity>();
    private final API3L1TransactionCreator api3L1TransactionCreator;
    private final TransactionSubmissionService transactionSubmissionService;
    private final LedgerUpdatedEventPublisher ledgerUpdatedEventPublisher;
    @Value(value="${lob.blockchain_publisher.dispatcher.pullBatchSize:50}")
    private int pullTransactionsBatchSize = 50;

    @Transactional
    public void dispatchReports() {
        log.info("Pooling for blockchain reports to be send to the blockchain...");
        for (Organisation organisation : this.organisationPublicApi.listAll()) {
            String organisationId = organisation.getId();
            Set<ReportEntity> reports = this.reportEntityRepositoryGateway.findReportsByStatus(organisationId, this.pullTransactionsBatchSize);
            int reportsCount = reports.size();
            log.info("Dispatching reports for organisationId: {}, report count:{}", (Object)organisationId, (Object)reportsCount);
            if (reportsCount <= 0) continue;
            Set<ReportEntity> toDispatch = this.dispatchingStrategy.apply(organisationId, reports);
            this.dispatchReports(organisationId, toDispatch);
        }
        log.info("Pooling for blockchain reports to be send to the blockchain...done");
    }

    @Transactional
    public void dispatchReports(String organisationId, Set<ReportEntity> reportEntities) {
        log.info("Dispatching reports for organisation: {}", (Object)organisationId);
        for (ReportEntity reportEntity : reportEntities) {
            this.dispatchReport(organisationId, reportEntity);
        }
    }

    @Transactional
    public void dispatchReport(String organisationId, ReportEntity reportEntity) {
        log.info("Dispatching report for organisation: {}", (Object)organisationId);
        Optional<API3BlockchainTransaction> api3BlockchainTransactionE = this.createAndSendBlockchainTransactions(reportEntity);
        if (api3BlockchainTransactionE.isEmpty()) {
            log.info("No more reports to dispatch for organisationId, success or error?, organisationId: {}", (Object)organisationId);
        }
    }

    @Transactional
    public Optional<API3BlockchainTransaction> createAndSendBlockchainTransactions(ReportEntity reportEntity) {
        log.info("Creating and sending blockchain transactions for report:{}", (Object)reportEntity.getReportId());
        Either<Problem, API3BlockchainTransaction> serialisedTxE = this.api3L1TransactionCreator.pullBlockchainTransaction(reportEntity);
        if (serialisedTxE.isLeft()) {
            Problem problem = (Problem)serialisedTxE.getLeft();
            log.error("Error pulling blockchain transaction, problem: {}", (Object)problem);
            return Optional.empty();
        }
        API3BlockchainTransaction serialisedTx = (API3BlockchainTransaction)serialisedTxE.get();
        try {
            this.sendTransactionOnChainAndUpdateDb(serialisedTx);
            return Optional.of(serialisedTx);
        }
        catch (ApiException | InterruptedException e) {
            log.error("Error sending transaction on chain and / or updating db", e);
            return Optional.empty();
        }
    }

    @Transactional
    public void sendTransactionOnChainAndUpdateDb(API3BlockchainTransaction api3BlockchainTransaction) throws ApiException, InterruptedException {
        byte[] reportTxData = api3BlockchainTransaction.serialisedTxData();
        L1Submission l1SubmissionData = this.transactionSubmissionService.submitTransactionWithPossibleConfirmation(reportTxData, api3BlockchainTransaction.receiverAddress());
        String txHash = l1SubmissionData.txHash();
        Optional<Long> txAbsoluteSlotM = l1SubmissionData.absoluteSlot();
        ReportEntity report = api3BlockchainTransaction.report();
        long creationSlot = api3BlockchainTransaction.creationSlot();
        this.updateTransactionStatuses(txHash, txAbsoluteSlotM, creationSlot, report);
        this.ledgerUpdatedEventPublisher.sendReportLedgerUpdatedEvents(report.getOrganisation().getId(), Set.of(report));
        log.info("Blockchain transaction submitted (report), l1SubmissionData:{}", (Object)l1SubmissionData);
    }

    @Transactional
    public void updateTransactionStatuses(String txHash, Optional<Long> absoluteSlot, long creationSlot, ReportEntity reportEntity) {
        reportEntity.setL1SubmissionData(Optional.of(L1SubmissionData.builder().transactionHash(txHash).absoluteSlot(absoluteSlot.orElse(null)).creationSlot(creationSlot).publishStatus(BlockchainPublishStatus.SUBMITTED).build()));
        this.reportEntityRepositoryGateway.storeReport(reportEntity);
    }

    public BlockchainReportsDispatcher(OrganisationPublicApi organisationPublicApi, ReportEntityRepositoryGateway reportEntityRepositoryGateway, API3L1TransactionCreator api3L1TransactionCreator, TransactionSubmissionService transactionSubmissionService, LedgerUpdatedEventPublisher ledgerUpdatedEventPublisher) {
        this.organisationPublicApi = organisationPublicApi;
        this.reportEntityRepositoryGateway = reportEntityRepositoryGateway;
        this.api3L1TransactionCreator = api3L1TransactionCreator;
        this.transactionSubmissionService = transactionSubmissionService;
        this.ledgerUpdatedEventPublisher = ledgerUpdatedEventPublisher;
    }
}

