/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.service;

import jakarta.persistence.OneToOne;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.CoreCurrency;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.Document;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.Organisation;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.Transaction;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.TransactionItem;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.TransactionType;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.BlockchainPublishStatus;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.AccountEvent;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.CostCenter;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Counterparty;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Currency;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.L1SubmissionData;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Project;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.TransactionEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.TransactionItemEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Vat;
import org.cardanofoundation.lob.app.blockchain_publisher.service.BlockchainPublishStatusMapper;
import org.cardanofoundation.lob.app.organisation.OrganisationPublicApi;
import org.cardanofoundation.lob.app.organisation.domain.entity.CostCenter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TransactionConverter {
    private static final Logger log = LoggerFactory.getLogger(TransactionConverter.class);
    private final BlockchainPublishStatusMapper blockchainPublishStatusMapper;
    private final OrganisationPublicApi organisationPublicApi;

    public TransactionEntity convertToDbDetached(Transaction tx) {
        TransactionEntity transactionEntity = new TransactionEntity();
        transactionEntity.setId(tx.getId());
        transactionEntity.setInternalNumber(tx.getInternalTransactionNumber());
        transactionEntity.setBatchId(tx.getBatchId());
        transactionEntity.setTransactionType(tx.getTransactionType());
        transactionEntity.setOrganisation(TransactionConverter.convertOrganisation(tx.getOrganisation()));
        transactionEntity.setEntryDate(tx.getEntryDate());
        transactionEntity.setAccountingPeriod(tx.getAccountingPeriod());
        BlockchainPublishStatus publishStatus = this.blockchainPublishStatusMapper.convert(tx.getLedgerDispatchStatus());
        transactionEntity.setL1SubmissionData(Optional.of(L1SubmissionData.builder().publishStatus(publishStatus).build()));
        Set<TransactionItemEntity> transactionItemEntities = this.convertTxItems(tx, transactionEntity);
        transactionEntity.setItems(this.aggregateTxItems(transactionItemEntities));
        return transactionEntity;
    }

    private Set<TransactionItemEntity> aggregateTxItems(Set<TransactionItemEntity> items) {
        return items.stream().collect(Collectors.groupingBy(TransactionItemEntity::aggregatedHash, Collectors.toSet())).values().stream().map(itemSet -> {
            TransactionItemEntity aggregatedItem = (TransactionItemEntity)((Object)((Object)itemSet.iterator().next()));
            aggregatedItem.setAmountFcy(itemSet.stream().map(TransactionItemEntity::getAmountFcy).reduce(BigDecimal.ZERO, BigDecimal::add));
            return aggregatedItem;
        }).collect(Collectors.toSet());
    }

    private Set<TransactionItemEntity> convertTxItems(Transaction tx, TransactionEntity transactionEntity) {
        return tx.getItems().stream().map(tl -> this.convertToDbDetached(transactionEntity, (TransactionItem)tl)).collect(Collectors.toSet());
    }

    private static org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Organisation convertOrganisation(Organisation org) {
        return org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Organisation.builder().id(org.getId()).name((String)org.getName().orElseThrow()).countryCode((String)org.getCountryCode().orElseThrow()).taxIdNumber((String)org.getTaxIdNumber().orElseThrow()).currencyId(org.getCurrencyId()).build();
    }

    private static org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Document convertDocument(Document doc) {
        return org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Document.builder().num(doc.getNumber()).currency(Currency.builder().id(((CoreCurrency)doc.getCurrency().getCoreCurrency().orElseThrow()).toExternalId()).customerCode(doc.getCurrency().getCustomerCode()).build()).vat(doc.getVat().map(vat -> Vat.builder().customerCode(vat.getCustomerCode()).rate((BigDecimal)vat.getRate().orElseThrow()).build()).orElse(null)).counterparty(doc.getCounterparty().map(cp -> Counterparty.builder().customerCode(cp.getCustomerCode()).type(cp.getType()).build()).orElse(null)).build();
    }

    @OneToOne
    public TransactionItemEntity convertToDbDetached(TransactionEntity parent, TransactionItem txItem) {
        TransactionItemEntity txItemEntity = new TransactionItemEntity();
        txItemEntity.setId(txItem.getId());
        txItemEntity.setTransaction(parent);
        txItemEntity.setAccountEvent(txItem.getAccountEvent().map(e -> AccountEvent.builder().code(e.getCode()).name(e.getName()).build()).orElse(null));
        txItemEntity.setFxRate(txItem.getFxRate());
        txItemEntity.setAmountFcy(txItem.getAmountFcy());
        if (parent.getTransactionType().equals((Object)TransactionType.FxRevaluation)) {
            txItemEntity.setAmountFcy(txItem.getAmountLcy());
        }
        txItemEntity.setDocument(TransactionConverter.convertDocument((Document)txItem.getDocument().orElseThrow()));
        txItemEntity.setCostCenter(txItem.getCostCenter().map(cc -> {
            CostCenter costCenter;
            if (Optional.ofNullable(cc.getCustomerCode()).isEmpty()) {
                return null;
            }
            CostCenter.CostCenterBuilder ccBuilder = org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.CostCenter.builder();
            cc.getName().ifPresent(ccBuilder::name);
            ccBuilder.customerCode(cc.getCustomerCode());
            Optional costCenterS = this.organisationPublicApi.findCostCenter(parent.getOrganisation().getId(), cc.getCustomerCode());
            if (costCenterS.isPresent() && (costCenter = (CostCenter)costCenterS.get()).getParent().isPresent()) {
                ccBuilder.customerCode(((CostCenter)costCenter.getParent().get()).getId().getCustomerCode());
                ccBuilder.name(((CostCenter)costCenter.getParent().get()).getName());
                return ccBuilder.build();
            }
            return ccBuilder.build();
        }).orElse(null));
        txItemEntity.setProject(txItem.getProject().map(pc -> Project.builder().customerCode(pc.getCustomerCode()).name((String)pc.getName().orElseThrow()).build()).orElse(null));
        return txItemEntity;
    }

    public TransactionConverter(BlockchainPublishStatusMapper blockchainPublishStatusMapper, OrganisationPublicApi organisationPublicApi) {
        this.blockchainPublishStatusMapper = blockchainPublishStatusMapper;
        this.organisationPublicApi = organisationPublicApi;
    }
}

