/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.service;

import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.Transaction;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.report.Report;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.reports.ReportEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.TransactionEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.repository.ReportEntityRepositoryGateway;
import org.cardanofoundation.lob.app.blockchain_publisher.repository.TransactionEntityRepositoryGateway;
import org.cardanofoundation.lob.app.blockchain_publisher.service.ReportConverter;
import org.cardanofoundation.lob.app.blockchain_publisher.service.TransactionConverter;
import org.cardanofoundation.lob.app.blockchain_publisher.service.event_publish.LedgerUpdatedEventPublisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="blockchain_publisher.blockchainPublisherService")
public class BlockchainPublisherService {
    private static final Logger log = LoggerFactory.getLogger(BlockchainPublisherService.class);
    private final TransactionEntityRepositoryGateway transactionEntityRepositoryGateway;
    private final ReportEntityRepositoryGateway reportEntityRepositoryGateway;
    private final LedgerUpdatedEventPublisher ledgerUpdatedEventPublisher;
    private final TransactionConverter transactionConverter;
    private final ReportConverter reportConverter;

    @Transactional
    public void storeTransactionForDispatchLater(String organisationId, Set<Transaction> txs) {
        log.info("dispatchTransactionsToBlockchains..., orgId:{}", (Object)organisationId);
        Set<TransactionEntity> txEntities = txs.stream().map(this.transactionConverter::convertToDbDetached).collect(Collectors.toSet());
        Set<TransactionEntity> storedTransactions = this.transactionEntityRepositoryGateway.storeOnlyNew(txEntities);
        this.ledgerUpdatedEventPublisher.sendTxLedgerUpdatedEvents(organisationId, storedTransactions);
    }

    @Transactional
    public void storeReportsForDispatchLater(String organisationId, Set<Report> reports) {
        log.info("storeReportsForDispatchLater..., orgId:{}", (Object)organisationId);
        Set<ReportEntity> storedReports = this.reportEntityRepositoryGateway.storeOnlyNew(reports.stream().map(this.reportConverter::convertToDbDetached).collect(Collectors.toSet()));
        this.ledgerUpdatedEventPublisher.sendReportLedgerUpdatedEvents(organisationId, storedReports);
    }

    public BlockchainPublisherService(TransactionEntityRepositoryGateway transactionEntityRepositoryGateway, ReportEntityRepositoryGateway reportEntityRepositoryGateway, LedgerUpdatedEventPublisher ledgerUpdatedEventPublisher, TransactionConverter transactionConverter, ReportConverter reportConverter) {
        this.transactionEntityRepositoryGateway = transactionEntityRepositoryGateway;
        this.reportEntityRepositoryGateway = reportEntityRepositoryGateway;
        this.ledgerUpdatedEventPublisher = ledgerUpdatedEventPublisher;
        this.transactionConverter = transactionConverter;
        this.reportConverter = reportConverter;
    }
}

