/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.service;

import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.backend.api.BackendService;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.function.helper.SignerProviders;
import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.metadata.MetadataBuilder;
import com.bloxbean.cardano.client.metadata.MetadataMap;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataMap;
import com.bloxbean.cardano.client.metadata.helper.MetadataToJsonNoSchemaConverter;
import com.bloxbean.cardano.client.quicktx.AbstractTx;
import com.bloxbean.cardano.client.quicktx.QuickTxBuilder;
import com.bloxbean.cardano.client.quicktx.Tx;
import com.bloxbean.cardano.client.transaction.util.TransactionUtil;
import com.google.common.collect.Sets;
import io.vavr.control.Either;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.cardanofoundation.lob.app.blockchain_common.service_assistance.MetadataChecker;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.API1BlockchainTransactions;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.SerializedCardanoL1Transaction;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.TransactionEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.service.API1MetadataSerialiser;
import org.cardanofoundation.lob.app.blockchain_reader.BlockchainReaderPublicApiIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;

public class API1L1TransactionCreator {
    private static final Logger log = LoggerFactory.getLogger(API1L1TransactionCreator.class);
    private static final int CARDANO_MAX_TRANSACTION_SIZE_BYTES = 16000;
    public static final String ERROR_SERIALISING_TRANSACTION_ABORT_PROCESSING_ISSUE = "Error serialising transaction, abort processing, issue: {}";
    private final BackendService backendService;
    private final API1MetadataSerialiser api1MetadataSerialiser;
    private final BlockchainReaderPublicApiIF blockchainReaderPublicApi;
    private final MetadataChecker jsonSchemaMetadataChecker;
    private final Account organiserAccount;
    private final int metadataLabel;
    private final boolean debugStoreOutputTx;
    private String runId;

    @PostConstruct
    public void init() {
        log.info("API1L1TransactionCreator::metadata label: {}", (Object)this.metadataLabel);
        log.info("API1L1TransactionCreator::debug store output tx: {}", (Object)this.debugStoreOutputTx);
        this.runId = UUID.randomUUID().toString();
        log.info("API1L1TransactionCreator::runId: {}", (Object)this.runId);
        log.info("API1L1TransactionCreator is initialised.");
    }

    public Either<Problem, Optional<API1BlockchainTransactions>> pullBlockchainTransaction(String organisationId, Set<TransactionEntity> txs) {
        return this.blockchainReaderPublicApi.getChainTip().flatMap(chainTip -> this.handleTransactionCreation(organisationId, txs, chainTip.getAbsoluteSlot()));
    }

    private Either<Problem, Optional<API1BlockchainTransactions>> handleTransactionCreation(String organisationId, Set<TransactionEntity> transactions, long creationSlot) {
        try {
            return this.createTransaction(organisationId, transactions, creationSlot);
        }
        catch (IOException e) {
            log.error("Error creating blockchain transaction: ", (Throwable)e);
            return Either.left((Object)Problem.builder().withTitle("ERROR_CREATING_TRANSACTION").withDetail("Exception encountered: %s".formatted(e.getMessage())).withStatus((StatusType)Status.INTERNAL_SERVER_ERROR).build());
        }
    }

    private Either<Problem, Optional<API1BlockchainTransactions>> createTransaction(String organisationId, Set<TransactionEntity> transactions, long creationSlot) throws IOException {
        log.info("Splitting {} passedTransactions into blockchain passedTransactions", (Object)transactions.size());
        LinkedHashSet<TransactionEntity> transactionsBatch = new LinkedHashSet<TransactionEntity>();
        PeekingIterator it = PeekingIterator.peekingIterator(transactions.iterator());
        while (it.hasNext()) {
            TransactionEntity txEntity = (TransactionEntity)((Object)it.next());
            transactionsBatch.add(txEntity);
            Either<Problem, SerializedCardanoL1Transaction> serializedTransactionsE = this.serialiseTransactionChunk(organisationId, transactionsBatch, creationSlot);
            if (serializedTransactionsE.isLeft()) {
                log.error(ERROR_SERIALISING_TRANSACTION_ABORT_PROCESSING_ISSUE, (Object)((Problem)serializedTransactionsE.getLeft()).getDetail());
                return Either.left((Object)((Problem)serializedTransactionsE.getLeft()));
            }
            SerializedCardanoL1Transaction serializedTransaction = (SerializedCardanoL1Transaction)serializedTransactionsE.get();
            byte[] txBytes = serializedTransaction.txBytes();
            TransactionEntity transactionLinePeek = (TransactionEntity)((Object)it.peek());
            if (transactionLinePeek == null) continue;
            Either<Problem, SerializedCardanoL1Transaction> newChunkTxBytesE = this.serialiseTransactionChunk(organisationId, Stream.concat(transactionsBatch.stream(), Stream.of(transactionLinePeek)).collect(Collectors.toSet()), creationSlot);
            if (newChunkTxBytesE.isLeft()) {
                log.error(ERROR_SERIALISING_TRANSACTION_ABORT_PROCESSING_ISSUE, (Object)((Problem)newChunkTxBytesE.getLeft()).getDetail());
                return Either.left((Object)((Problem)newChunkTxBytesE.getLeft()));
            }
            SerializedCardanoL1Transaction newSerializedTransaction = (SerializedCardanoL1Transaction)newChunkTxBytesE.get();
            byte[] newChunkTxBytes = newSerializedTransaction.txBytes();
            if (newChunkTxBytes.length < 16000) continue;
            log.info("Blockchain transaction created, id:{}", (Object)TransactionUtil.getTxHash((byte[])txBytes));
            log.info("Blockchain transaction created, id:{}, debugTxOutput:{}", (Object)TransactionUtil.getTxHash((byte[])txBytes), (Object)this.debugStoreOutputTx);
            this.potentiallyStoreTxs(creationSlot, serializedTransaction);
            Set<TransactionEntity> remainingTxs = API1L1TransactionCreator.calculateRemainingTransactions(transactions, transactionsBatch);
            return Either.right(Optional.of(new API1BlockchainTransactions(organisationId, transactionsBatch, remainingTxs, creationSlot, txBytes, this.organiserAccount.baseAddress())));
        }
        if (!transactionsBatch.isEmpty()) {
            log.info("Leftovers batch size: {}", (Object)transactionsBatch.size());
            Either<Problem, SerializedCardanoL1Transaction> serializedTxE = this.serialiseTransactionChunk(organisationId, transactionsBatch, creationSlot);
            if (serializedTxE.isEmpty()) {
                log.error(ERROR_SERIALISING_TRANSACTION_ABORT_PROCESSING_ISSUE, (Object)((Problem)serializedTxE.getLeft()).getDetail());
                return Either.left((Object)((Problem)serializedTxE.getLeft()));
            }
            SerializedCardanoL1Transaction serTx = (SerializedCardanoL1Transaction)serializedTxE.get();
            byte[] txBytes = serTx.txBytes();
            log.info("Blockchain transaction created, id:{}, debugTxOutput:{}", (Object)TransactionUtil.getTxHash((byte[])txBytes), (Object)this.debugStoreOutputTx);
            this.potentiallyStoreTxs(creationSlot, serTx);
            log.info("Transaction size: {}", (Object)txBytes.length);
            Set<TransactionEntity> remaining = API1L1TransactionCreator.calculateRemainingTransactions(transactions, transactionsBatch);
            return Either.right(Optional.of(new API1BlockchainTransactions(organisationId, transactionsBatch, remaining, creationSlot, txBytes, this.organiserAccount.baseAddress())));
        }
        return Either.right(Optional.empty());
    }

    private void potentiallyStoreTxs(long creationSlot, SerializedCardanoL1Transaction tx) throws IOException {
        if (this.debugStoreOutputTx) {
            String timestamp = DateTimeFormatter.ISO_INSTANT.format(Instant.now());
            String name = "lob-txs-api1-metadata-%s-%s-%s".formatted(this.runId, timestamp, creationSlot);
            Path tmpJsonTxFile = Files.createTempFile(name, ".json", new FileAttribute[0]);
            Path tmpCborFile = Files.createTempFile(name, ".cbor", new FileAttribute[0]);
            log.info("DebugStoreTx enabled, storing JSON tx metadata to file: {}", (Object)tmpJsonTxFile);
            Files.writeString(tmpJsonTxFile, (CharSequence)tx.metadataJson(), new OpenOption[0]);
            log.info("DebugStoreTx enabled, storing CBOR tx metadata to file: {}", (Object)tmpCborFile);
            Files.write(tmpCborFile, tx.metadataCbor(), new OpenOption[0]);
        }
    }

    private static Set<TransactionEntity> calculateRemainingTransactions(Set<TransactionEntity> transactions, Set<TransactionEntity> transactionsBatch) {
        return Sets.difference(transactions, transactionsBatch);
    }

    private Either<Problem, SerializedCardanoL1Transaction> serialiseTransactionChunk(String organisationId, Set<TransactionEntity> transactionsBatch, long creationSlot) {
        try {
            MetadataMap metadataMap = this.api1MetadataSerialiser.serialiseToMetadataMap(organisationId, transactionsBatch, creationSlot);
            Map data = metadataMap.getMap();
            byte[] bytes = CborSerializationUtil.serialize((DataItem)data);
            String json = MetadataToJsonNoSchemaConverter.cborBytesToJson((byte[])bytes);
            boolean isValid = this.jsonSchemaMetadataChecker.checkTransactionMetadata(json);
            if (!isValid) {
                return Either.left((Object)Problem.builder().withTitle("INVALID_TRANSACTION_METADATA").withDetail("Metadata is not valid according to the transaction schema, we will not create a transaction!").withStatus((StatusType)Status.INTERNAL_SERVER_ERROR).build());
            }
            Metadata metadata = MetadataBuilder.createMetadata();
            CBORMetadataMap cborMetadataMap = new CBORMetadataMap(data);
            metadata.put((long)this.metadataLabel, (MetadataMap)cborMetadataMap);
            log.info("Metadata for tx validated, gonna serialise tx now...");
            byte[] serialisedTx = this.serialiseTransaction(metadata);
            return Either.right((Object)new SerializedCardanoL1Transaction(serialisedTx, bytes, json));
        }
        catch (Exception e) {
            log.error("Error serialising metadata to cbor", (Throwable)e);
            return Either.left((Object)Problem.builder().withTitle("ERROR_SERIALISING_METADATA").withDetail("Error serialising metadata to cbor").withStatus((StatusType)Status.INTERNAL_SERVER_ERROR).build());
        }
    }

    protected byte[] serialiseTransaction(Metadata metadata) throws CborSerializationException {
        QuickTxBuilder quickTxBuilder = new QuickTxBuilder(this.backendService);
        Tx tx = ((Tx)((Tx)new Tx().payToAddress(this.organiserAccount.baseAddress(), Amount.ada((Double)2.0))).attachMetadata(metadata)).from(this.organiserAccount.baseAddress());
        return quickTxBuilder.compose(new AbstractTx[]{tx}).withSigner(SignerProviders.signerFrom((Account[])new Account[]{this.organiserAccount})).buildAndSign().serialize();
    }

    public API1L1TransactionCreator(BackendService backendService, API1MetadataSerialiser api1MetadataSerialiser, BlockchainReaderPublicApiIF blockchainReaderPublicApi, MetadataChecker jsonSchemaMetadataChecker, Account organiserAccount, int metadataLabel, boolean debugStoreOutputTx) {
        this.backendService = backendService;
        this.api1MetadataSerialiser = api1MetadataSerialiser;
        this.blockchainReaderPublicApi = blockchainReaderPublicApi;
        this.jsonSchemaMetadataChecker = jsonSchemaMetadataChecker;
        this.organiserAccount = organiserAccount;
        this.metadataLabel = metadataLabel;
        this.debugStoreOutputTx = debugStoreOutputTx;
    }
}

