/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.job;

import jakarta.annotation.PostConstruct;
import org.cardanofoundation.lob.app.blockchain_publisher.service.dispatch.BlockchainReportsDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service(value="blockchain_publisher.ReportsDispatcherJob")
@ConditionalOnProperty(value={"lob.blockchain_publisher.enabled"}, havingValue="true", matchIfMissing=true)
public class ReportsDispatcherJob {
    private static final Logger log = LoggerFactory.getLogger(ReportsDispatcherJob.class);
    private final BlockchainReportsDispatcher blockchainReportsDispatcher;

    @PostConstruct
    public void init() {
        log.info("blockchain_publisher.ReportsDispatcherJob is enabled.");
    }

    @Scheduled(fixedDelayString="${lob.blockchain_publisher.dispatcher.report.fixed_delay:PT10S}", initialDelayString="${lob.blockchain_publisher.dispatcher.report.initial_delay:PT1M}")
    public void execute() {
        log.info("Pooling for report blockchain transactions to be send to the blockchain...");
        this.blockchainReportsDispatcher.dispatchReports();
        log.info("Pooling for report blockchain transactions to be send to the blockchain...done");
    }

    public ReportsDispatcherJob(BlockchainReportsDispatcher blockchainReportsDispatcher) {
        this.blockchainReportsDispatcher = blockchainReportsDispatcher;
    }
}

