/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.TransactionType;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.L1SubmissionData;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Organisation;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.TransactionItemEntity;
import org.cardanofoundation.lob.app.support.spring_audit.CommonDateOnlyLockableEntity;
import org.hibernate.annotations.JdbcType;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;
import org.springframework.data.domain.Persistable;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity(name="blockchain_publisher.txs.TransactionEntity")
@Table(name="blockchain_publisher_transaction")
@EntityListeners(value={AuditingEntityListener.class})
@Access(value=AccessType.FIELD)
public class TransactionEntity
extends CommonDateOnlyLockableEntity
implements Persistable<String> {
    @Id
    @Column(name="transaction_id", nullable=false)
    private String id;
    @Column(name="internal_number", nullable=false)
    private String internalNumber;
    @Column(name="batch_id", nullable=false)
    private String batchId;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="id", column=@Column(name="organisation_id")), @AttributeOverride(name="name", column=@Column(name="organisation_name")), @AttributeOverride(name="taxIdNumber", column=@Column(name="organisation_tax_id_number")), @AttributeOverride(name="countryCode", column=@Column(name="organisation_country_code")), @AttributeOverride(name="currencyId", column=@Column(name="organisation_currency_id"))})
    private Organisation organisation;
    @Column(name="type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private TransactionType transactionType;
    @Column(name="entry_date", nullable=false)
    private LocalDate entryDate;
    @Column(name="accounting_period", nullable=false)
    private YearMonth accountingPeriod;
    @Nullable
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="transactionHash", column=@Column(name="l1_transaction_hash")), @AttributeOverride(name="absoluteSlot", column=@Column(name="l1_absolute_slot")), @AttributeOverride(name="creationSlot", column=@Column(name="l1_creation_slot")), @AttributeOverride(name="finalityScore", column=@Column(name="l1_finality_score")), @AttributeOverride(name="publishStatus", column=@Column(name="l1_publish_status"))})
    private L1SubmissionData l1SubmissionData;
    @OneToMany(mappedBy="transaction", orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<TransactionItemEntity> items;

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof TransactionEntity) {
            TransactionEntity te = (TransactionEntity)((Object)obj);
            return this.id.equals(te.getId());
        }
        return false;
    }

    public Optional<L1SubmissionData> getL1SubmissionData() {
        return Optional.ofNullable(this.l1SubmissionData);
    }

    public void setL1SubmissionData(Optional<L1SubmissionData> l1SubmissionData) {
        this.l1SubmissionData = l1SubmissionData.orElse(null);
    }

    public String getId() {
        return this.id;
    }

    private static Set<TransactionItemEntity> $default$items() {
        return new LinkedHashSet<TransactionItemEntity>();
    }

    public static TransactionEntityBuilder builder() {
        return new TransactionEntityBuilder();
    }

    public String getInternalNumber() {
        return this.internalNumber;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public Organisation getOrganisation() {
        return this.organisation;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public LocalDate getEntryDate() {
        return this.entryDate;
    }

    public YearMonth getAccountingPeriod() {
        return this.accountingPeriod;
    }

    public Set<TransactionItemEntity> getItems() {
        return this.items;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setInternalNumber(String internalNumber) {
        this.internalNumber = internalNumber;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public void setOrganisation(Organisation organisation) {
        this.organisation = organisation;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public void setEntryDate(LocalDate entryDate) {
        this.entryDate = entryDate;
    }

    public void setAccountingPeriod(YearMonth accountingPeriod) {
        this.accountingPeriod = accountingPeriod;
    }

    public void setItems(Set<TransactionItemEntity> items) {
        this.items = items;
    }

    public TransactionEntity() {
        this.items = TransactionEntity.$default$items();
    }

    public TransactionEntity(String id, String internalNumber, String batchId, Organisation organisation, TransactionType transactionType, LocalDate entryDate, YearMonth accountingPeriod, @Nullable L1SubmissionData l1SubmissionData, Set<TransactionItemEntity> items) {
        this.id = id;
        this.internalNumber = internalNumber;
        this.batchId = batchId;
        this.organisation = organisation;
        this.transactionType = transactionType;
        this.entryDate = entryDate;
        this.accountingPeriod = accountingPeriod;
        this.l1SubmissionData = l1SubmissionData;
        this.items = items;
    }

    public static class TransactionEntityBuilder {
        private String id;
        private String internalNumber;
        private String batchId;
        private Organisation organisation;
        private TransactionType transactionType;
        private LocalDate entryDate;
        private YearMonth accountingPeriod;
        private L1SubmissionData l1SubmissionData;
        private boolean items$set;
        private Set<TransactionItemEntity> items$value;

        TransactionEntityBuilder() {
        }

        public TransactionEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        public TransactionEntityBuilder internalNumber(String internalNumber) {
            this.internalNumber = internalNumber;
            return this;
        }

        public TransactionEntityBuilder batchId(String batchId) {
            this.batchId = batchId;
            return this;
        }

        public TransactionEntityBuilder organisation(Organisation organisation) {
            this.organisation = organisation;
            return this;
        }

        public TransactionEntityBuilder transactionType(TransactionType transactionType) {
            this.transactionType = transactionType;
            return this;
        }

        public TransactionEntityBuilder entryDate(LocalDate entryDate) {
            this.entryDate = entryDate;
            return this;
        }

        public TransactionEntityBuilder accountingPeriod(YearMonth accountingPeriod) {
            this.accountingPeriod = accountingPeriod;
            return this;
        }

        public TransactionEntityBuilder l1SubmissionData(@Nullable L1SubmissionData l1SubmissionData) {
            this.l1SubmissionData = l1SubmissionData;
            return this;
        }

        public TransactionEntityBuilder items(Set<TransactionItemEntity> items) {
            this.items$value = items;
            this.items$set = true;
            return this;
        }

        public TransactionEntity build() {
            Set<TransactionItemEntity> items$value = this.items$value;
            if (!this.items$set) {
                items$value = TransactionEntity.$default$items();
            }
            return new TransactionEntity(this.id, this.internalNumber, this.batchId, this.organisation, this.transactionType, this.entryDate, this.accountingPeriod, this.l1SubmissionData, items$value);
        }

        public String toString() {
            return "TransactionEntity.TransactionEntityBuilder(id=" + this.id + ", internalNumber=" + this.internalNumber + ", batchId=" + this.batchId + ", organisation=" + String.valueOf(this.organisation) + ", transactionType=" + String.valueOf(this.transactionType) + ", entryDate=" + String.valueOf(this.entryDate) + ", accountingPeriod=" + String.valueOf(this.accountingPeriod) + ", l1SubmissionData=" + String.valueOf(this.l1SubmissionData) + ", items$value=" + String.valueOf(this.items$value) + ")";
        }
    }
}

