/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs;

import jakarta.persistence.Embeddable;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import java.util.Optional;
import javax.annotation.Nullable;
import org.cardanofoundation.lob.app.blockchain_common.domain.FinalityScore;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.BlockchainPublishStatus;
import org.hibernate.annotations.JdbcType;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;

@Embeddable
public class L1SubmissionData {
    @Nullable
    private String transactionHash;
    @Nullable
    private Long absoluteSlot;
    @Nullable
    private Long creationSlot;
    @Nullable
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private BlockchainPublishStatus publishStatus;
    @Nullable
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private FinalityScore finalityScore;

    public Optional<String> getTransactionHash() {
        return Optional.ofNullable(this.transactionHash);
    }

    public Optional<Long> getAbsoluteSlot() {
        return Optional.ofNullable(this.absoluteSlot);
    }

    public Optional<Long> getCreationSlot() {
        return Optional.ofNullable(this.creationSlot);
    }

    public Optional<FinalityScore> getFinalityScore() {
        return Optional.ofNullable(this.finalityScore);
    }

    public Optional<BlockchainPublishStatus> getPublishStatus() {
        return Optional.ofNullable(this.publishStatus);
    }

    public void setFinalityScore(FinalityScore assuranceLevel) {
        this.finalityScore = assuranceLevel;
    }

    public void setPublishStatus(BlockchainPublishStatus publishStatus) {
        this.publishStatus = publishStatus;
    }

    public void setAbsoluteSlot(Long absoluteSlot) {
        this.absoluteSlot = absoluteSlot;
    }

    public void setCreationSlot(Long creationSlot) {
        this.creationSlot = creationSlot;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public boolean isFinalized() {
        return this.finalityScore != null && this.finalityScore.equals((Object)FinalityScore.FINAL);
    }

    public static L1SubmissionDataBuilder builder() {
        return new L1SubmissionDataBuilder();
    }

    public L1SubmissionDataBuilder toBuilder() {
        return new L1SubmissionDataBuilder().transactionHash(this.transactionHash).absoluteSlot(this.absoluteSlot).creationSlot(this.creationSlot).publishStatus(this.publishStatus).finalityScore(this.finalityScore);
    }

    public L1SubmissionData() {
    }

    public String toString() {
        return "L1SubmissionData(transactionHash=" + String.valueOf(this.getTransactionHash()) + ", absoluteSlot=" + String.valueOf(this.getAbsoluteSlot()) + ", creationSlot=" + String.valueOf(this.getCreationSlot()) + ", publishStatus=" + String.valueOf(this.getPublishStatus()) + ", finalityScore=" + String.valueOf(this.getFinalityScore()) + ")";
    }

    public L1SubmissionData(@Nullable String transactionHash, @Nullable Long absoluteSlot, @Nullable Long creationSlot, @Nullable BlockchainPublishStatus publishStatus, @Nullable FinalityScore finalityScore) {
        this.transactionHash = transactionHash;
        this.absoluteSlot = absoluteSlot;
        this.creationSlot = creationSlot;
        this.publishStatus = publishStatus;
        this.finalityScore = finalityScore;
    }

    public static class L1SubmissionDataBuilder {
        private String transactionHash;
        private Long absoluteSlot;
        private Long creationSlot;
        private BlockchainPublishStatus publishStatus;
        private FinalityScore finalityScore;

        L1SubmissionDataBuilder() {
        }

        public L1SubmissionDataBuilder transactionHash(@Nullable String transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        public L1SubmissionDataBuilder absoluteSlot(@Nullable Long absoluteSlot) {
            this.absoluteSlot = absoluteSlot;
            return this;
        }

        public L1SubmissionDataBuilder creationSlot(@Nullable Long creationSlot) {
            this.creationSlot = creationSlot;
            return this;
        }

        public L1SubmissionDataBuilder publishStatus(@Nullable BlockchainPublishStatus publishStatus) {
            this.publishStatus = publishStatus;
            return this;
        }

        public L1SubmissionDataBuilder finalityScore(@Nullable FinalityScore finalityScore) {
            this.finalityScore = finalityScore;
            return this;
        }

        public L1SubmissionData build() {
            return new L1SubmissionData(this.transactionHash, this.absoluteSlot, this.creationSlot, this.publishStatus, this.finalityScore);
        }

        public String toString() {
            return "L1SubmissionData.L1SubmissionDataBuilder(transactionHash=" + this.transactionHash + ", absoluteSlot=" + this.absoluteSlot + ", creationSlot=" + this.creationSlot + ", publishStatus=" + String.valueOf((Object)this.publishStatus) + ", finalityScore=" + String.valueOf(this.finalityScore) + ")";
        }
    }
}

