/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs;

import jakarta.persistence.Embeddable;
import java.util.Objects;

@Embeddable
public class AccountEvent {
    private String code;
    private String name;

    public int hashCode() {
        return Objects.hash(this.code, this.name);
    }

    public static AccountEventBuilder builder() {
        return new AccountEventBuilder();
    }

    public AccountEvent(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public AccountEvent() {
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class AccountEventBuilder {
        private String code;
        private String name;

        AccountEventBuilder() {
        }

        public AccountEventBuilder code(String code) {
            this.code = code;
            return this;
        }

        public AccountEventBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AccountEvent build() {
            return new AccountEvent(this.code, this.name);
        }

        public String toString() {
            return "AccountEvent.AccountEventBuilder(code=" + this.code + ", name=" + this.name + ")";
        }
    }
}

