/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.service.transation_submit;

import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.BackendService;
import com.bloxbean.cardano.client.backend.model.TransactionContent;
import com.bloxbean.cardano.client.transaction.util.TransactionUtil;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.L1Submission;
import org.cardanofoundation.lob.app.blockchain_publisher.service.transation_submit.BlockchainTransactionSubmissionService;
import org.cardanofoundation.lob.app.blockchain_publisher.service.transation_submit.TransactionSubmissionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransactionSubmissionService
implements TransactionSubmissionService {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransactionSubmissionService.class);
    private final BlockchainTransactionSubmissionService transactionSubmissionService;
    private final BackendService backendService;
    private final UtxoSupplier utxoSupplier;
    private final Clock clock;
    private final int sleepTimeSeconds;
    private final int timeoutInSeconds;

    @Override
    public String submitTransaction(byte[] txData) {
        log.info("Submitting transaction without confirmation.., txId:{}", (Object)TransactionUtil.getTxHash((byte[])txData));
        return this.transactionSubmissionService.submitTransaction(txData);
    }

    @Override
    public L1Submission submitTransactionWithPossibleConfirmation(byte[] txData, String receiverAddress) throws ApiException, InterruptedException {
        log.info("Submitting transaction with confirmation.., txId:{}", (Object)TransactionUtil.getTxHash((byte[])txData));
        String txHash = this.submitTransaction(txData);
        LocalDateTime start = LocalDateTime.now(this.clock);
        LocalDateTime future = start.plusSeconds(this.timeoutInSeconds);
        while (LocalDateTime.now(this.clock).isBefore(future)) {
            Result transactionDetailsR = this.backendService.getTransactionService().getTransaction(txHash);
            if (!transactionDetailsR.isSuccessful()) {
                log.warn("Transaction not found on chain yet. Sleeping for {} seconds... until deadline:{}", (Object)this.sleepTimeSeconds, (Object)future);
                try {
                    Thread.sleep((long)this.sleepTimeSeconds * 1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    log.error("Thread interrupted while waiting for transaction confirmation", (Throwable)e);
                    throw new InterruptedException("Thread interrupted while waiting for transaction confirmation");
                }
            }
            TransactionContent transactionContent = (TransactionContent)transactionDetailsR.getValue();
            Long absoluteSlot = transactionContent.getSlot();
            this.checkIfUtxoAvailable(txHash, receiverAddress);
            return new L1Submission(txHash, Optional.of(absoluteSlot), true);
        }
        return new L1Submission(txHash, Optional.empty(), false);
    }

    protected void checkIfUtxoAvailable(String txHash, String address) {
        Optional<Object> utxo = Optional.empty();
        int count = 0;
        while (utxo.isEmpty() && count++ < 50) {
            List utxos = this.utxoSupplier.getAll(address);
            utxo = utxos.stream().filter(u -> u.getTxHash().equals(txHash)).findFirst();
            log.info("Try to get new output... txhash: " + txHash);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.error("Thread interrupted while waiting for UTXO availability", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public DefaultTransactionSubmissionService(BlockchainTransactionSubmissionService transactionSubmissionService, BackendService backendService, UtxoSupplier utxoSupplier, Clock clock, int sleepTimeSeconds, int timeoutInSeconds) {
        this.transactionSubmissionService = transactionSubmissionService;
        this.backendService = backendService;
        this.utxoSupplier = utxoSupplier;
        this.clock = clock;
        this.sleepTimeSeconds = sleepTimeSeconds;
        this.timeoutInSeconds = timeoutInSeconds;
    }
}

