/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.service.event_publish;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.BlockchainReceipt;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.LedgerDispatchStatus;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.ReportStatusUpdate;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.TxStatusUpdate;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.event.ledger.ReportsLedgerUpdatedEvent;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.event.ledger.TxsLedgerUpdatedEvent;
import org.cardanofoundation.lob.app.blockchain_common.domain.FinalityScore;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.BlockchainPublishStatus;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.reports.ReportEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.L1SubmissionData;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.TransactionEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.service.BlockchainPublishStatusMapper;
import org.cardanofoundation.lob.app.support.collections.Partitions;
import org.cardanofoundation.lob.app.support.modulith.EventMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LedgerUpdatedEventPublisher {
    private static final Logger log = LoggerFactory.getLogger(LedgerUpdatedEventPublisher.class);
    private final ApplicationEventPublisher applicationEventPublisher;
    private final BlockchainPublishStatusMapper blockchainPublishStatusMapper;
    private static String BLOCKCHAIN_TYPE = "CARDANO_L1";
    @Value(value="${lob.blockchain_publisher.send.batch.size:100}")
    protected int dispatchBatchSize = 100;

    @Transactional
    public void sendTxLedgerUpdatedEvents(String organisationId, Set<TransactionEntity> allTxs) {
        log.info("Sending tx ledger updated event for organisation:{}, submittedTransactions:{}", (Object)organisationId, (Object)allTxs.size());
        Iterable partitions = Partitions.partition(allTxs, (int)this.dispatchBatchSize);
        for (Partitions.Partition partition : partitions) {
            Set txStatuses = partition.asSet().stream().map(txEntity -> {
                Optional<BlockchainPublishStatus> publishStatusM = txEntity.getL1SubmissionData().flatMap(L1SubmissionData::getPublishStatus);
                Optional<FinalityScore> cardanoFinalityScoreM = txEntity.getL1SubmissionData().flatMap(L1SubmissionData::getFinalityScore);
                LedgerDispatchStatus ledgerDispatchStatus = this.blockchainPublishStatusMapper.convert(publishStatusM, cardanoFinalityScoreM);
                String txId = txEntity.getId();
                Optional blockchainHashM = txEntity.getL1SubmissionData().flatMap(L1SubmissionData::getTransactionHash);
                if (blockchainHashM.isEmpty()) {
                    return new TxStatusUpdate(txId, ledgerDispatchStatus, Set.of());
                }
                String blockchainHash = (String)blockchainHashM.get();
                Set<BlockchainReceipt> blockchainReceipts = Set.of(new BlockchainReceipt(BLOCKCHAIN_TYPE, blockchainHash));
                return new TxStatusUpdate(txId, ledgerDispatchStatus, blockchainReceipts);
            }).collect(Collectors.toSet());
            log.info("Sending txs ledger updated event for organisation:{}, statuses:{}", (Object)organisationId, txStatuses);
            TxsLedgerUpdatedEvent event = TxsLedgerUpdatedEvent.builder().metadata(EventMetadata.create((String)"1.0")).organisationId(organisationId).statusUpdates(txStatuses).build();
            this.applicationEventPublisher.publishEvent((Object)event);
        }
    }

    @Transactional
    public void sendReportLedgerUpdatedEvents(String organisationId, Set<ReportEntity> reports) {
        log.info("Sending report ledger updated event for organisation:{}, reports:{}", (Object)organisationId, (Object)reports.size());
        Iterable partitions = Partitions.partition(reports, (int)this.dispatchBatchSize);
        for (Partitions.Partition partition : partitions) {
            Set reportStatuses = partition.asSet().stream().map(reportEntity -> {
                Optional<BlockchainPublishStatus> publishStatusM = reportEntity.getL1SubmissionData().flatMap(L1SubmissionData::getPublishStatus);
                Optional<FinalityScore> cardanoFinalityScoreM = reportEntity.getL1SubmissionData().flatMap(L1SubmissionData::getFinalityScore);
                LedgerDispatchStatus ledgerDispatchStatus = this.blockchainPublishStatusMapper.convert(publishStatusM, cardanoFinalityScoreM);
                String reportId = reportEntity.getReportId();
                Optional blockchainHashM = reportEntity.getL1SubmissionData().flatMap(L1SubmissionData::getTransactionHash);
                if (blockchainHashM.isEmpty()) {
                    return new ReportStatusUpdate(reportId, ledgerDispatchStatus, Set.of());
                }
                String blockchainHash = (String)blockchainHashM.get();
                Set<BlockchainReceipt> blockchainReceipts = Set.of(new BlockchainReceipt(BLOCKCHAIN_TYPE, blockchainHash));
                return new ReportStatusUpdate(reportId, ledgerDispatchStatus, blockchainReceipts);
            }).collect(Collectors.toSet());
            log.info("Sending report ledger updated event for organisation:{}, statuses: {}", (Object)organisationId, reportStatuses);
            ReportsLedgerUpdatedEvent event = ReportsLedgerUpdatedEvent.builder().metadata(EventMetadata.create((String)"1.0")).organisationId(organisationId).statusUpdates(reportStatuses).build();
            this.applicationEventPublisher.publishEvent((Object)event);
        }
    }

    public LedgerUpdatedEventPublisher(ApplicationEventPublisher applicationEventPublisher, BlockchainPublishStatusMapper blockchainPublishStatusMapper) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.blockchainPublishStatusMapper = blockchainPublishStatusMapper;
    }
}

