/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.service.event_handle;

import org.cardanofoundation.lob.app.accounting_reporting_core.domain.event.ledger.ReportLedgerUpdateCommand;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.event.ledger.TransactionLedgerUpdateCommand;
import org.cardanofoundation.lob.app.blockchain_publisher.service.BlockchainPublisherService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"lob.blockchain_publisher.enabled"}, havingValue="true", matchIfMissing=true)
public class BlockchainPublisherEventHandler {
    private static final Logger log = LoggerFactory.getLogger(BlockchainPublisherEventHandler.class);
    private final BlockchainPublisherService blockchainPublisherService;

    @EventListener
    @Async
    public void handleLedgerUpdateCommand(TransactionLedgerUpdateCommand command) {
        log.info("Received LedgerUpdateCommand: {}", (Object)command);
        this.blockchainPublisherService.storeTransactionForDispatchLater(command.getOrganisationId(), command.getTransactions());
    }

    @EventListener
    @Async
    public void handleLedgerUpdateCommand(ReportLedgerUpdateCommand command) {
        log.info("Received ReportLedgerUpdateCommand: {}", (Object)command);
        this.blockchainPublisherService.storeReportsForDispatchLater(command.getOrganisationId(), command.getReports());
    }

    public BlockchainPublisherEventHandler(BlockchainPublisherService blockchainPublisherService) {
        this.blockchainPublisherService = blockchainPublisherService;
    }
}

