/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.service.dispatch;

import jakarta.annotation.PostConstruct;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cardanofoundation.lob.app.blockchain_publisher.service.dispatch.DispatchingStrategy;
import org.cardanofoundation.lob.app.support.spring_audit.CommonDateOnlyEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="lob.dispatching_strategy", name={"type"}, havingValue="DELAYED", matchIfMissing=true)
public class DelayedDispatchingStrategy<T extends CommonDateOnlyEntity>
implements DispatchingStrategy<T> {
    private static final Logger log = LoggerFactory.getLogger(DelayedDispatchingStrategy.class);
    @Value(value="${lob.blockchain_publisher.minTransactions:30}")
    private int minTxCount = 30;
    @Value(value="${lob.blockchain_publisher.maxDelay:PT24H}")
    private Duration maxTxDelay;
    private final Clock clock;

    @PostConstruct
    public void init() {
        log.info("DefaultDispatchingStrategy initialized with minTransactions:{}, maxDelay:{}", (Object)this.minTxCount, (Object)this.maxTxDelay);
    }

    @Override
    public Set<T> apply(String organisationId, Set<T> txs) {
        LocalDateTime now = LocalDateTime.now(this.clock);
        Set prioritisedTransactions = txs.stream().filter(tx -> {
            LocalDateTime mustPublishDate = tx.getCreatedAt().plus(this.maxTxDelay);
            return now.isAfter(mustPublishDate);
        }).collect(Collectors.toSet());
        if (!prioritisedTransactions.isEmpty()) {
            log.info("Found prioritised transactions for organisationId:{}, count:{}", (Object)organisationId, (Object)prioritisedTransactions.size());
            return new LinkedHashSet(Stream.concat(prioritisedTransactions.stream(), txs.stream()).toList());
        }
        log.info("Extracted {} passedTransactions for organisationId:{}", (Object)txs.size(), (Object)organisationId);
        if (txs.size() < this.minTxCount) {
            log.warn("Not enough passedTransactions to dispatch for organisationId:{}", (Object)organisationId);
            return Set.of();
        }
        return txs;
    }

    public DelayedDispatchingStrategy(Clock clock) {
        this.clock = clock;
    }
}

