/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.service;

import io.vavr.control.Either;
import jakarta.annotation.PostConstruct;
import java.util.Optional;
import java.util.Set;
import org.cardanofoundation.lob.app.blockchain_common.domain.ChainTip;
import org.cardanofoundation.lob.app.blockchain_common.domain.FinalityScore;
import org.cardanofoundation.lob.app.blockchain_common.domain.OnChainTxDetails;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.BlockchainPublishStatus;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.OnChainStatus;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.reports.ReportEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.L1SubmissionData;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.TransactionEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.repository.ReportEntityRepositoryGateway;
import org.cardanofoundation.lob.app.blockchain_publisher.repository.TransactionEntityRepositoryGateway;
import org.cardanofoundation.lob.app.blockchain_publisher.service.BlockchainPublishStatusMapper;
import org.cardanofoundation.lob.app.blockchain_publisher.service.event_publish.LedgerUpdatedEventPublisher;
import org.cardanofoundation.lob.app.blockchain_reader.BlockchainReaderPublicApiIF;
import org.cardanofoundation.lob.app.organisation.OrganisationPublicApiIF;
import org.cardanofoundation.lob.app.organisation.domain.entity.Organisation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Limit;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WatchDogService {
    private static final Logger log = LoggerFactory.getLogger(WatchDogService.class);
    private final OrganisationPublicApiIF organisationPublicApiIF;
    private final BlockchainPublishStatusMapper blockchainPublishStatusMapper;
    private final BlockchainReaderPublicApiIF blockchainReaderPublicApi;
    private final TransactionEntityRepositoryGateway transactionEntityRepositoryGateway;
    private final ReportEntityRepositoryGateway reportEntityRepositoryGateway;
    private final LedgerUpdatedEventPublisher ledgerUpdatedEventPublisher;
    @Value(value="${lob.blockchain_publisher.watchdog.rollback.grace.period.minutes:15}")
    private int rollbackGracePeriodMinutes = 15;

    @PostConstruct
    public void init() {
        log.info("TransactionsWatchDogService configuration: rollbackGracePeriodMinutes={}, rollbacksEnabled={}", (Object)this.rollbackGracePeriodMinutes);
        log.info("TransactionsWatchDogService started");
    }

    public void checkReportStatusForOrganisations(int txStatusInspectionLimitPerOrgPullSize) {
        this.organisationPublicApiIF.listAll().forEach(org -> {
            log.info("Checking report statuses for organisation: {}", (Object)org.getName());
            this.checkReportStatusForOrganisation((Organisation)org, txStatusInspectionLimitPerOrgPullSize);
        });
    }

    @Transactional
    public void checkTransactionStatusForOrganisations(int txStatusInspectionLimitPerOrgPullSize) {
        this.organisationPublicApiIF.listAll().forEach(org -> {
            log.info("Checking transaction statuses for organisation: {}", (Object)org.getName());
            this.checkTransactionStatusesForOrganisation((Organisation)org, txStatusInspectionLimitPerOrgPullSize);
        });
    }

    private void checkReportStatusForOrganisation(Organisation org, int txStatusInspectionLimitPerOrgPullSize) {
        ChainTip chainTip = this.getChainTip();
        if (!chainTip.isSynced()) {
            log.info("Chain is not synced, skipping transaction status check for organisation: {}", (Object)org.getName());
            return;
        }
        Set<ReportEntity> reportEntities = this.reportEntityRepositoryGateway.findDispatchedReportsThatAreNotFinalizedYet(org.getId(), Limit.of((int)txStatusInspectionLimitPerOrgPullSize));
        reportEntities.forEach(report -> {
            log.info("Checking transaction status for report: {}", (Object)report.getId());
            L1SubmissionData l1SubmissionData = report.getL1SubmissionData().orElseThrow(() -> new RuntimeException("Failed to get L1 submission data"));
            report.setL1SubmissionData(Optional.of(this.updateL1SubmissionData(l1SubmissionData, chainTip)));
            this.reportEntityRepositoryGateway.storeReport((ReportEntity)((Object)report));
            log.info("Status updated for report: {}", (Object)report.getId());
        });
        this.ledgerUpdatedEventPublisher.sendReportLedgerUpdatedEvents(org.getId(), reportEntities);
    }

    private void checkTransactionStatusesForOrganisation(Organisation org, int txStatusInspectionLimitPerOrgPullSize) {
        ChainTip chainTip = this.getChainTip();
        if (!chainTip.isSynced()) {
            log.info("Chain is not synced, skipping transaction status check for organisation: {}", (Object)org.getName());
            return;
        }
        Set<TransactionEntity> successfullyUpdatedTxEntities = this.transactionEntityRepositoryGateway.findDispatchedTransactionsThatAreNotFinalizedYet(org.getId(), Limit.of((int)txStatusInspectionLimitPerOrgPullSize));
        successfullyUpdatedTxEntities.forEach(tx -> {
            log.info("Checking transaction status for transaction: {}", (Object)tx.getId());
            L1SubmissionData l1SubmissionData1 = tx.getL1SubmissionData().orElseThrow(() -> new RuntimeException("Failed to get L1 submission data"));
            tx.setL1SubmissionData(Optional.of(this.updateL1SubmissionData(l1SubmissionData1, chainTip)));
        });
        this.transactionEntityRepositoryGateway.storeTransactions(successfullyUpdatedTxEntities);
        log.info("Status updated for {} transactions", (Object)successfullyUpdatedTxEntities.size());
        this.ledgerUpdatedEventPublisher.sendTxLedgerUpdatedEvents(org.getId(), successfullyUpdatedTxEntities);
    }

    private OnChainStatus getOnChainStatus(Optional<OnChainTxDetails> onChainTxDetails, Long txCreationSlot, ChainTip chainTip) {
        boolean isRollbackReadyTimewise;
        if (onChainTxDetails.isPresent()) {
            return new OnChainStatus(this.blockchainPublishStatusMapper.convert(onChainTxDetails.get().getFinalityScore()), Optional.of(onChainTxDetails.get().getFinalityScore()));
        }
        long txAgeInSlots = chainTip.getAbsoluteSlot() - txCreationSlot;
        boolean bl = isRollbackReadyTimewise = txAgeInSlots > (long)this.rollbackGracePeriodMinutes * 60L;
        if (isRollbackReadyTimewise) {
            return new OnChainStatus(BlockchainPublishStatus.ROLLBACKED, Optional.empty());
        }
        return new OnChainStatus(BlockchainPublishStatus.SUBMITTED, Optional.of(FinalityScore.VERY_LOW));
    }

    private L1SubmissionData updateL1SubmissionData(L1SubmissionData submissionData, ChainTip chainTip) {
        Long txCreationSlot = submissionData.getCreationSlot().orElseThrow(() -> new RuntimeException("Failed to get tx creation slot"));
        String txHash = submissionData.getTransactionHash().orElseThrow(() -> new RuntimeException("Failed to get tx hash"));
        log.info("Checking transaction status changes for txHash:{}", (Object)txHash);
        Either txDetails = this.blockchainReaderPublicApi.getTxDetails(txHash);
        Optional onChainTxDetails = (Optional)txDetails.getOrElseThrow(() -> {
            log.error("Failed to get tx details for txHash:{}", (Object)txHash);
            return new RuntimeException("Failed to get tx details for txHash:" + txHash);
        });
        OnChainStatus onChainStatus = this.getOnChainStatus(onChainTxDetails, txCreationSlot, chainTip);
        if (onChainStatus.status().equals((Object)BlockchainPublishStatus.ROLLBACKED)) {
            submissionData.setPublishStatus(BlockchainPublishStatus.ROLLBACKED);
            submissionData.setCreationSlot(null);
            submissionData.setAbsoluteSlot(null);
            submissionData.setTransactionHash(null);
            submissionData.setFinalityScore(null);
        } else {
            submissionData.setFinalityScore(onChainStatus.finalityScore().get());
            submissionData.setPublishStatus(onChainStatus.status());
        }
        return submissionData;
    }

    private ChainTip getChainTip() {
        return (ChainTip)this.blockchainReaderPublicApi.getChainTip().getOrElseThrow(() -> {
            log.error("Failed to get chain tip");
            return new RuntimeException("Failed to get chain tip");
        });
    }

    public WatchDogService(OrganisationPublicApiIF organisationPublicApiIF, BlockchainPublishStatusMapper blockchainPublishStatusMapper, BlockchainReaderPublicApiIF blockchainReaderPublicApi, TransactionEntityRepositoryGateway transactionEntityRepositoryGateway, ReportEntityRepositoryGateway reportEntityRepositoryGateway, LedgerUpdatedEventPublisher ledgerUpdatedEventPublisher) {
        this.organisationPublicApiIF = organisationPublicApiIF;
        this.blockchainPublishStatusMapper = blockchainPublishStatusMapper;
        this.blockchainReaderPublicApi = blockchainReaderPublicApi;
        this.transactionEntityRepositoryGateway = transactionEntityRepositoryGateway;
        this.reportEntityRepositoryGateway = reportEntityRepositoryGateway;
        this.ledgerUpdatedEventPublisher = ledgerUpdatedEventPublisher;
    }

    public int getRollbackGracePeriodMinutes() {
        return this.rollbackGracePeriodMinutes;
    }

    public void setRollbackGracePeriodMinutes(int rollbackGracePeriodMinutes) {
        this.rollbackGracePeriodMinutes = rollbackGracePeriodMinutes;
    }
}

