/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.service;

import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.backend.api.BackendService;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.function.helper.SignerProviders;
import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.metadata.MetadataBuilder;
import com.bloxbean.cardano.client.metadata.MetadataMap;
import com.bloxbean.cardano.client.metadata.cbor.CBORMetadataMap;
import com.bloxbean.cardano.client.metadata.helper.MetadataToJsonNoSchemaConverter;
import com.bloxbean.cardano.client.quicktx.AbstractTx;
import com.bloxbean.cardano.client.quicktx.QuickTxBuilder;
import com.bloxbean.cardano.client.quicktx.Tx;
import io.vavr.control.Either;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.cardanofoundation.lob.app.blockchain_common.service_assistance.MetadataChecker;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.API3BlockchainTransaction;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.SerializedCardanoL1Transaction;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.reports.ReportEntity;
import org.cardanofoundation.lob.app.blockchain_publisher.service.API3MetadataSerialiser;
import org.cardanofoundation.lob.app.blockchain_reader.BlockchainReaderPublicApiIF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;
import org.zalando.problem.StatusType;

public class API3L1TransactionCreator {
    private static final Logger log = LoggerFactory.getLogger(API3L1TransactionCreator.class);
    private final BackendService backendService;
    private final API3MetadataSerialiser api3MetadataSerialiser;
    private final BlockchainReaderPublicApiIF blockchainReaderPublicApi;
    private final MetadataChecker jsonSchemaMetadataChecker;
    private final Account organiserAccount;
    private final int metadataLabel;
    private final boolean debugStoreOutputTx;
    private String runId;

    @PostConstruct
    public void init() {
        log.info("API3L1TransactionCreator::metadata label: {}", (Object)this.metadataLabel);
        log.info("API3L1TransactionCreator::debug store output tx: {}", (Object)this.debugStoreOutputTx);
        this.runId = UUID.randomUUID().toString();
        log.info("API3L1TransactionCreator::runId: {}", (Object)this.runId);
        log.info("API3L1TransactionCreator is initialised.");
    }

    public Either<Problem, API3BlockchainTransaction> pullBlockchainTransaction(ReportEntity reportEntity) {
        return this.blockchainReaderPublicApi.getChainTip().flatMap(chainTip -> this.handleTransactionCreation(reportEntity, chainTip.getAbsoluteSlot()));
    }

    private Either<Problem, API3BlockchainTransaction> handleTransactionCreation(ReportEntity reportEntity, long creationSlot) {
        try {
            MetadataMap metadataMap = this.api3MetadataSerialiser.serialiseToMetadataMap(reportEntity, creationSlot);
            Map data = metadataMap.getMap();
            byte[] bytes = CborSerializationUtil.serialize((DataItem)data);
            String json = MetadataToJsonNoSchemaConverter.cborBytesToJson((byte[])bytes);
            Metadata metadata = MetadataBuilder.createMetadata();
            CBORMetadataMap cborMetadataMap = new CBORMetadataMap(data);
            metadata.put((long)this.metadataLabel, (MetadataMap)cborMetadataMap);
            boolean isValid = this.jsonSchemaMetadataChecker.checkTransactionMetadata(json);
            if (!isValid) {
                return Either.left((Object)Problem.builder().withTitle("INVALID_TRANSACTION_METADATA").withDetail("Metadata is not valid according to the transaction schema, we will not create a transaction!").withStatus((StatusType)Status.INTERNAL_SERVER_ERROR).build());
            }
            log.info("Metadata for tx validated, gonna serialise tx now...");
            byte[] serialisedTxBytes = this.serialiseTransaction(metadata);
            SerializedCardanoL1Transaction serializedTx = new SerializedCardanoL1Transaction(serialisedTxBytes, bytes, json);
            this.potentiallyStoreTxs(creationSlot, serializedTx);
            return Either.right((Object)new API3BlockchainTransaction(reportEntity, creationSlot, serialisedTxBytes, this.organiserAccount.baseAddress()));
        }
        catch (Exception e) {
            log.error("Error serialising metadata to cbor", (Throwable)e);
            return Either.left((Object)Problem.builder().withTitle("ERROR_SERIALISING_METADATA").withDetail("Error serialising metadata to cbor").withStatus((StatusType)Status.INTERNAL_SERVER_ERROR).build());
        }
    }

    private void potentiallyStoreTxs(long creationSlot, SerializedCardanoL1Transaction tx) throws IOException {
        if (this.debugStoreOutputTx) {
            String timestamp = DateTimeFormatter.ISO_INSTANT.format(Instant.now());
            String name = "lob-txs-api3-metadata-%s-%s-%s".formatted(this.runId, timestamp, creationSlot);
            Path tmpJsonTxFile = Files.createTempFile(name, ".json", new FileAttribute[0]);
            Path tmpCborFile = Files.createTempFile(name, ".cbor", new FileAttribute[0]);
            log.info("DebugStoreTx enabled, storing JSON tx metadata to file: {}", (Object)tmpJsonTxFile);
            Files.writeString(tmpJsonTxFile, (CharSequence)tx.metadataJson(), new OpenOption[0]);
            log.info("DebugStoreTx enabled, storing CBOR tx metadata to file: {}", (Object)tmpCborFile);
            Files.write(tmpCborFile, tx.metadataCbor(), new OpenOption[0]);
        }
    }

    protected byte[] serialiseTransaction(Metadata metadata) throws CborSerializationException {
        QuickTxBuilder quickTxBuilder = new QuickTxBuilder(this.backendService);
        Tx tx = ((Tx)((Tx)new Tx().payToAddress(this.organiserAccount.baseAddress(), Amount.ada((Double)2.0))).attachMetadata(metadata)).from(this.organiserAccount.baseAddress());
        return quickTxBuilder.compose(new AbstractTx[]{tx}).withSigner(SignerProviders.signerFrom((Account[])new Account[]{this.organiserAccount})).buildAndSign().serialize();
    }

    public API3L1TransactionCreator(BackendService backendService, API3MetadataSerialiser api3MetadataSerialiser, BlockchainReaderPublicApiIF blockchainReaderPublicApi, MetadataChecker jsonSchemaMetadataChecker, Account organiserAccount, int metadataLabel, boolean debugStoreOutputTx) {
        this.backendService = backendService;
        this.api3MetadataSerialiser = api3MetadataSerialiser;
        this.blockchainReaderPublicApi = blockchainReaderPublicApi;
        this.jsonSchemaMetadataChecker = jsonSchemaMetadataChecker;
        this.organiserAccount = organiserAccount;
        this.metadataLabel = metadataLabel;
        this.debugStoreOutputTx = debugStoreOutputTx;
    }
}

