/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.repository;

import java.time.LocalDateTime;
import java.util.Set;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.core.BlockchainPublishStatus;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.TransactionEntity;
import org.springframework.data.domain.Limit;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface TransactionEntityRepository
extends JpaRepository<TransactionEntity, String> {
    @Query(value="SELECT t FROM blockchain_publisher.txs.TransactionEntity t WHERE t.organisation.id = :organisationId AND t.l1SubmissionData.publishStatus IN :publishStatuses ORDER BY t.createdAt ASC, t.id ASC")
    public Set<TransactionEntity> findTransactionsByStatus(@Param(value="organisationId") String var1, @Param(value="publishStatuses") Set<BlockchainPublishStatus> var2, Limit var3);

    @Query(value="SELECT t FROM blockchain_publisher.txs.TransactionEntity t\nWHERE t.organisation.id = :organisationId\nAND t.l1SubmissionData.publishStatus IN :publishStatuses\nAND (t.lockedAt IS NULL OR t.lockedAt < :lockTime)\nORDER BY t.createdAt ASC, t.id ASC")
    public Set<TransactionEntity> findFreeTransactionsByStatus(@Param(value="organisationId") String var1, @Param(value="publishStatuses") Set<BlockchainPublishStatus> var2, @Param(value="lockTime") LocalDateTime var3, Limit var4);

    @Query(value="SELECT t FROM blockchain_publisher.txs.TransactionEntity t WHERE t.organisation.id = :organisationId AND t.l1SubmissionData.publishStatus IN :publishStatuses AND t.l1SubmissionData is NOT NULL ORDER BY t.createdAt ASC, t.id ASC")
    public Set<TransactionEntity> findDispatchedTransactionsThatAreNotFinalizedYet(@Param(value="organisationId") String var1, @Param(value="publishStatuses") Set<BlockchainPublishStatus> var2, Limit var3);
}

