/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.job;

import jakarta.annotation.PostConstruct;
import org.cardanofoundation.lob.app.blockchain_publisher.service.dispatch.BlockchainTransactionsDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service(value="blockchain_publisher.TransactionDispatcherJob")
@ConditionalOnProperty(value={"lob.blockchain_publisher.enabled"}, havingValue="true", matchIfMissing=true)
public class TransactionDispatcherJob {
    private static final Logger log = LoggerFactory.getLogger(TransactionDispatcherJob.class);
    private final BlockchainTransactionsDispatcher blockchainTransactionsDispatcher;

    @PostConstruct
    public void init() {
        log.info("blockchain_publisher.TransactionDispatcherJob is enabled.");
    }

    @Scheduled(fixedDelayString="${lob.blockchain_publisher.dispatcher.txs.fixed_delay:PT10S}", initialDelayString="${lob.blockchain_publisher.dispatcher.txs.initial_delay:PT1M}")
    public void execute() {
        log.info("Pooling for blockchain transactions to be send to the blockchain...");
        this.blockchainTransactionsDispatcher.dispatchTransactions();
        log.info("Pooling for blockchain transactions to be send to the blockchain...done");
    }

    public TransactionDispatcherJob(BlockchainTransactionsDispatcher blockchainTransactionsDispatcher) {
        this.blockchainTransactionsDispatcher = blockchainTransactionsDispatcher;
    }
}

