/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs;

import jakarta.persistence.Embeddable;
import jakarta.validation.constraints.NotBlank;
import java.util.Objects;

@Embeddable
public class Project {
    @NotBlank
    private String customerCode;
    @NotBlank
    private String name;

    public int hashCode() {
        return Objects.hash(this.customerCode, this.name);
    }

    public static ProjectBuilder builder() {
        return new ProjectBuilder();
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public String getName() {
        return this.name;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Project() {
    }

    public String toString() {
        return "Project(customerCode=" + this.getCustomerCode() + ", name=" + this.getName() + ")";
    }

    public Project(String customerCode, String name) {
        this.customerCode = customerCode;
        this.name = name;
    }

    public static class ProjectBuilder {
        private String customerCode;
        private String name;

        ProjectBuilder() {
        }

        public ProjectBuilder customerCode(String customerCode) {
            this.customerCode = customerCode;
            return this;
        }

        public ProjectBuilder name(String name) {
            this.name = name;
            return this;
        }

        public Project build() {
            return new Project(this.customerCode, this.name);
        }

        public String toString() {
            return "Project.ProjectBuilder(customerCode=" + this.customerCode + ", name=" + this.name + ")";
        }
    }
}

