/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs;

import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Counterparty;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Currency;
import org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs.Vat;

@Embeddable
public class Document {
    private String num;
    @Embedded
    private Currency currency;
    @Embedded
    @Nullable
    private Vat vat;
    @Nullable
    @Embedded
    private Counterparty counterparty;

    public Optional<Vat> getVat() {
        return Optional.ofNullable(this.vat);
    }

    public Optional<Counterparty> getCounterparty() {
        return Optional.ofNullable(this.counterparty);
    }

    public void setCounterparty(Optional<Counterparty> counterparty) {
        this.counterparty = counterparty.orElse(null);
    }

    public int hashCode() {
        return Objects.hash(this.num, this.currency, this.vat, this.counterparty);
    }

    public static DocumentBuilder builder() {
        return new DocumentBuilder();
    }

    public DocumentBuilder toBuilder() {
        return new DocumentBuilder().num(this.num).currency(this.currency).vat(this.vat).counterparty(this.counterparty);
    }

    public String getNum() {
        return this.num;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setVat(@Nullable Vat vat) {
        this.vat = vat;
    }

    public Document() {
    }

    public String toString() {
        return "Document(num=" + this.getNum() + ", currency=" + String.valueOf(this.getCurrency()) + ", vat=" + String.valueOf(this.getVat()) + ", counterparty=" + String.valueOf(this.getCounterparty()) + ")";
    }

    public Document(String num, Currency currency, @Nullable Vat vat, @Nullable Counterparty counterparty) {
        this.num = num;
        this.currency = currency;
        this.vat = vat;
        this.counterparty = counterparty;
    }

    public static class DocumentBuilder {
        private String num;
        private Currency currency;
        private Vat vat;
        private Counterparty counterparty;

        DocumentBuilder() {
        }

        public DocumentBuilder num(String num) {
            this.num = num;
            return this;
        }

        public DocumentBuilder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public DocumentBuilder vat(@Nullable Vat vat) {
            this.vat = vat;
            return this;
        }

        public DocumentBuilder counterparty(@Nullable Counterparty counterparty) {
            this.counterparty = counterparty;
            return this;
        }

        public Document build() {
            return new Document(this.num, this.currency, this.vat, this.counterparty);
        }

        public String toString() {
            return "Document.DocumentBuilder(num=" + this.num + ", currency=" + String.valueOf(this.currency) + ", vat=" + String.valueOf(this.vat) + ", counterparty=" + String.valueOf(this.counterparty) + ")";
        }
    }
}

