/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs;

import jakarta.persistence.Embeddable;
import java.util.Objects;

@Embeddable
public class Currency {
    private String customerCode;
    private String id;

    public int hashCode() {
        return Objects.hash(this.customerCode, this.id);
    }

    public static CurrencyBuilder builder() {
        return new CurrencyBuilder();
    }

    public Currency() {
    }

    public Currency(String customerCode, String id) {
        this.customerCode = customerCode;
        this.id = id;
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public String getId() {
        return this.id;
    }

    public static class CurrencyBuilder {
        private String customerCode;
        private String id;

        CurrencyBuilder() {
        }

        public CurrencyBuilder customerCode(String customerCode) {
            this.customerCode = customerCode;
            return this;
        }

        public CurrencyBuilder id(String id) {
            this.id = id;
            return this;
        }

        public Currency build() {
            return new Currency(this.customerCode, this.id);
        }

        public String toString() {
            return "Currency.CurrencyBuilder(customerCode=" + this.customerCode + ", id=" + this.id + ")";
        }
    }
}

