/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs;

import jakarta.persistence.Embeddable;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import java.util.Objects;
import org.cardanofoundation.lob.app.accounting_reporting_core.domain.core.Counterparty;
import org.hibernate.annotations.JdbcType;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;

@Embeddable
public class Counterparty {
    private String customerCode;
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private Counterparty.Type type;

    public int hashCode() {
        return Objects.hash(this.customerCode, this.type);
    }

    public static CounterpartyBuilder builder() {
        return new CounterpartyBuilder();
    }

    public Counterparty(String customerCode, Counterparty.Type type) {
        this.customerCode = customerCode;
        this.type = type;
    }

    public Counterparty() {
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public Counterparty.Type getType() {
        return this.type;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public void setType(Counterparty.Type type) {
        this.type = type;
    }

    public static class CounterpartyBuilder {
        private String customerCode;
        private Counterparty.Type type;

        CounterpartyBuilder() {
        }

        public CounterpartyBuilder customerCode(String customerCode) {
            this.customerCode = customerCode;
            return this;
        }

        public CounterpartyBuilder type(Counterparty.Type type) {
            this.type = type;
            return this;
        }

        public Counterparty build() {
            return new Counterparty(this.customerCode, this.type);
        }

        public String toString() {
            return "Counterparty.CounterpartyBuilder(customerCode=" + this.customerCode + ", type=" + String.valueOf(this.type) + ")";
        }
    }
}

