/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.txs;

import jakarta.persistence.Embeddable;
import jakarta.validation.constraints.NotBlank;
import java.util.Objects;

@Embeddable
public class CostCenter {
    @NotBlank
    private String customerCode;
    @NotBlank
    private String name;

    public int hashCode() {
        return Objects.hash(this.customerCode, this.name);
    }

    public static CostCenterBuilder builder() {
        return new CostCenterBuilder();
    }

    public String getCustomerCode() {
        return this.customerCode;
    }

    public String getName() {
        return this.name;
    }

    public void setCustomerCode(String customerCode) {
        this.customerCode = customerCode;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CostCenter() {
    }

    public String toString() {
        return "CostCenter(customerCode=" + this.getCustomerCode() + ", name=" + this.getName() + ")";
    }

    public CostCenter(String customerCode, String name) {
        this.customerCode = customerCode;
        this.name = name;
    }

    public static class CostCenterBuilder {
        private String customerCode;
        private String name;

        CostCenterBuilder() {
        }

        public CostCenterBuilder customerCode(String customerCode) {
            this.customerCode = customerCode;
            return this;
        }

        public CostCenterBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CostCenter build() {
            return new CostCenter(this.customerCode, this.name);
        }

        public String toString() {
            return "CostCenter.CostCenterBuilder(customerCode=" + this.customerCode + ", name=" + this.name + ")";
        }
    }
}

