/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.domain.entity.reports;

import jakarta.persistence.Embeddable;
import java.math.BigDecimal;
import java.util.Optional;
import javax.annotation.Nullable;

@Embeddable
public class BalanceSheetData {
    @Nullable
    private Assets assets;
    @Nullable
    private Liabilities liabilities;
    @Nullable
    private Capital capital;

    public Optional<Assets> getAssets() {
        return Optional.ofNullable(this.assets);
    }

    public Optional<Liabilities> getLiabilities() {
        return Optional.ofNullable(this.liabilities);
    }

    public Optional<Capital> getCapital() {
        return Optional.ofNullable(this.capital);
    }

    public static BalanceSheetDataBuilder builder() {
        return new BalanceSheetDataBuilder();
    }

    public BalanceSheetDataBuilder toBuilder() {
        return new BalanceSheetDataBuilder().assets(this.assets).liabilities(this.liabilities).capital(this.capital);
    }

    public BalanceSheetData(@Nullable Assets assets, @Nullable Liabilities liabilities, @Nullable Capital capital) {
        this.assets = assets;
        this.liabilities = liabilities;
        this.capital = capital;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BalanceSheetData)) {
            return false;
        }
        BalanceSheetData other = (BalanceSheetData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Optional<Assets> this$assets = this.getAssets();
        Optional<Assets> other$assets = other.getAssets();
        if (this$assets == null ? other$assets != null : !((Object)this$assets).equals(other$assets)) {
            return false;
        }
        Optional<Liabilities> this$liabilities = this.getLiabilities();
        Optional<Liabilities> other$liabilities = other.getLiabilities();
        if (this$liabilities == null ? other$liabilities != null : !((Object)this$liabilities).equals(other$liabilities)) {
            return false;
        }
        Optional<Capital> this$capital = this.getCapital();
        Optional<Capital> other$capital = other.getCapital();
        return !(this$capital == null ? other$capital != null : !((Object)this$capital).equals(other$capital));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BalanceSheetData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<Assets> $assets = this.getAssets();
        result = result * 59 + ($assets == null ? 43 : ((Object)$assets).hashCode());
        Optional<Liabilities> $liabilities = this.getLiabilities();
        result = result * 59 + ($liabilities == null ? 43 : ((Object)$liabilities).hashCode());
        Optional<Capital> $capital = this.getCapital();
        result = result * 59 + ($capital == null ? 43 : ((Object)$capital).hashCode());
        return result;
    }

    public String toString() {
        return "BalanceSheetData(assets=" + String.valueOf(this.getAssets()) + ", liabilities=" + String.valueOf(this.getLiabilities()) + ", capital=" + String.valueOf(this.getCapital()) + ")";
    }

    public BalanceSheetData() {
    }

    @Embeddable
    public static class Assets {
        @Nullable
        private NonCurrentAssets nonCurrentAssets;
        @Nullable
        private CurrentAssets currentAssets;

        public Optional<NonCurrentAssets> getNonCurrentAssets() {
            return Optional.ofNullable(this.nonCurrentAssets);
        }

        public Optional<CurrentAssets> getCurrentAssets() {
            return Optional.ofNullable(this.currentAssets);
        }

        public static AssetsBuilder builder() {
            return new AssetsBuilder();
        }

        public AssetsBuilder toBuilder() {
            return new AssetsBuilder().nonCurrentAssets(this.nonCurrentAssets).currentAssets(this.currentAssets);
        }

        public Assets(@Nullable NonCurrentAssets nonCurrentAssets, @Nullable CurrentAssets currentAssets) {
            this.nonCurrentAssets = nonCurrentAssets;
            this.currentAssets = currentAssets;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Assets)) {
                return false;
            }
            Assets other = (Assets)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<NonCurrentAssets> this$nonCurrentAssets = this.getNonCurrentAssets();
            Optional<NonCurrentAssets> other$nonCurrentAssets = other.getNonCurrentAssets();
            if (this$nonCurrentAssets == null ? other$nonCurrentAssets != null : !((Object)this$nonCurrentAssets).equals(other$nonCurrentAssets)) {
                return false;
            }
            Optional<CurrentAssets> this$currentAssets = this.getCurrentAssets();
            Optional<CurrentAssets> other$currentAssets = other.getCurrentAssets();
            return !(this$currentAssets == null ? other$currentAssets != null : !((Object)this$currentAssets).equals(other$currentAssets));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Assets;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<NonCurrentAssets> $nonCurrentAssets = this.getNonCurrentAssets();
            result = result * 59 + ($nonCurrentAssets == null ? 43 : ((Object)$nonCurrentAssets).hashCode());
            Optional<CurrentAssets> $currentAssets = this.getCurrentAssets();
            result = result * 59 + ($currentAssets == null ? 43 : ((Object)$currentAssets).hashCode());
            return result;
        }

        public String toString() {
            return "BalanceSheetData.Assets(nonCurrentAssets=" + String.valueOf(this.getNonCurrentAssets()) + ", currentAssets=" + String.valueOf(this.getCurrentAssets()) + ")";
        }

        public Assets() {
        }

        @Embeddable
        public static class NonCurrentAssets {
            @Nullable
            private BigDecimal tangibleAssets;
            @Nullable
            private BigDecimal intangibleAssets;
            @Nullable
            private BigDecimal investments;
            @Nullable
            private BigDecimal financialAssets;

            public Optional<BigDecimal> getTangibleAssets() {
                return Optional.ofNullable(this.tangibleAssets);
            }

            public Optional<BigDecimal> getIntangibleAssets() {
                return Optional.ofNullable(this.intangibleAssets);
            }

            public Optional<BigDecimal> getInvestments() {
                return Optional.ofNullable(this.investments);
            }

            public Optional<BigDecimal> getFinancialAssets() {
                return Optional.ofNullable(this.financialAssets);
            }

            public static NonCurrentAssetsBuilder builder() {
                return new NonCurrentAssetsBuilder();
            }

            public NonCurrentAssetsBuilder toBuilder() {
                return new NonCurrentAssetsBuilder().tangibleAssets(this.tangibleAssets).intangibleAssets(this.intangibleAssets).investments(this.investments).financialAssets(this.financialAssets);
            }

            public NonCurrentAssets(@Nullable BigDecimal tangibleAssets, @Nullable BigDecimal intangibleAssets, @Nullable BigDecimal investments, @Nullable BigDecimal financialAssets) {
                this.tangibleAssets = tangibleAssets;
                this.intangibleAssets = intangibleAssets;
                this.investments = investments;
                this.financialAssets = financialAssets;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NonCurrentAssets)) {
                    return false;
                }
                NonCurrentAssets other = (NonCurrentAssets)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Optional<BigDecimal> this$tangibleAssets = this.getTangibleAssets();
                Optional<BigDecimal> other$tangibleAssets = other.getTangibleAssets();
                if (this$tangibleAssets == null ? other$tangibleAssets != null : !((Object)this$tangibleAssets).equals(other$tangibleAssets)) {
                    return false;
                }
                Optional<BigDecimal> this$intangibleAssets = this.getIntangibleAssets();
                Optional<BigDecimal> other$intangibleAssets = other.getIntangibleAssets();
                if (this$intangibleAssets == null ? other$intangibleAssets != null : !((Object)this$intangibleAssets).equals(other$intangibleAssets)) {
                    return false;
                }
                Optional<BigDecimal> this$investments = this.getInvestments();
                Optional<BigDecimal> other$investments = other.getInvestments();
                if (this$investments == null ? other$investments != null : !((Object)this$investments).equals(other$investments)) {
                    return false;
                }
                Optional<BigDecimal> this$financialAssets = this.getFinancialAssets();
                Optional<BigDecimal> other$financialAssets = other.getFinancialAssets();
                return !(this$financialAssets == null ? other$financialAssets != null : !((Object)this$financialAssets).equals(other$financialAssets));
            }

            protected boolean canEqual(Object other) {
                return other instanceof NonCurrentAssets;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Optional<BigDecimal> $tangibleAssets = this.getTangibleAssets();
                result = result * 59 + ($tangibleAssets == null ? 43 : ((Object)$tangibleAssets).hashCode());
                Optional<BigDecimal> $intangibleAssets = this.getIntangibleAssets();
                result = result * 59 + ($intangibleAssets == null ? 43 : ((Object)$intangibleAssets).hashCode());
                Optional<BigDecimal> $investments = this.getInvestments();
                result = result * 59 + ($investments == null ? 43 : ((Object)$investments).hashCode());
                Optional<BigDecimal> $financialAssets = this.getFinancialAssets();
                result = result * 59 + ($financialAssets == null ? 43 : ((Object)$financialAssets).hashCode());
                return result;
            }

            public String toString() {
                return "BalanceSheetData.Assets.NonCurrentAssets(tangibleAssets=" + String.valueOf(this.getTangibleAssets()) + ", intangibleAssets=" + String.valueOf(this.getIntangibleAssets()) + ", investments=" + String.valueOf(this.getInvestments()) + ", financialAssets=" + String.valueOf(this.getFinancialAssets()) + ")";
            }

            public NonCurrentAssets() {
            }

            public static class NonCurrentAssetsBuilder {
                private BigDecimal tangibleAssets;
                private BigDecimal intangibleAssets;
                private BigDecimal investments;
                private BigDecimal financialAssets;

                NonCurrentAssetsBuilder() {
                }

                public NonCurrentAssetsBuilder tangibleAssets(@Nullable BigDecimal tangibleAssets) {
                    this.tangibleAssets = tangibleAssets;
                    return this;
                }

                public NonCurrentAssetsBuilder intangibleAssets(@Nullable BigDecimal intangibleAssets) {
                    this.intangibleAssets = intangibleAssets;
                    return this;
                }

                public NonCurrentAssetsBuilder investments(@Nullable BigDecimal investments) {
                    this.investments = investments;
                    return this;
                }

                public NonCurrentAssetsBuilder financialAssets(@Nullable BigDecimal financialAssets) {
                    this.financialAssets = financialAssets;
                    return this;
                }

                public NonCurrentAssets build() {
                    return new NonCurrentAssets(this.tangibleAssets, this.intangibleAssets, this.investments, this.financialAssets);
                }

                public String toString() {
                    return "BalanceSheetData.Assets.NonCurrentAssets.NonCurrentAssetsBuilder(tangibleAssets=" + String.valueOf(this.tangibleAssets) + ", intangibleAssets=" + String.valueOf(this.intangibleAssets) + ", investments=" + String.valueOf(this.investments) + ", financialAssets=" + String.valueOf(this.financialAssets) + ")";
                }
            }
        }

        @Embeddable
        public static class CurrentAssets {
            @Nullable
            private BigDecimal prepaymentsAndOtherShortTermAssets;
            @Nullable
            private BigDecimal otherReceivables;
            @Nullable
            private BigDecimal cryptoAssets;
            @Nullable
            private BigDecimal cashAndCashEquivalents;

            public Optional<BigDecimal> getPrepaymentsAndOtherShortTermAssets() {
                return Optional.ofNullable(this.prepaymentsAndOtherShortTermAssets);
            }

            public Optional<BigDecimal> getOtherReceivables() {
                return Optional.ofNullable(this.otherReceivables);
            }

            public Optional<BigDecimal> getCryptoAssets() {
                return Optional.ofNullable(this.cryptoAssets);
            }

            public Optional<BigDecimal> getCashAndCashEquivalents() {
                return Optional.ofNullable(this.cashAndCashEquivalents);
            }

            public static CurrentAssetsBuilder builder() {
                return new CurrentAssetsBuilder();
            }

            public CurrentAssetsBuilder toBuilder() {
                return new CurrentAssetsBuilder().prepaymentsAndOtherShortTermAssets(this.prepaymentsAndOtherShortTermAssets).otherReceivables(this.otherReceivables).cryptoAssets(this.cryptoAssets).cashAndCashEquivalents(this.cashAndCashEquivalents);
            }

            public CurrentAssets(@Nullable BigDecimal prepaymentsAndOtherShortTermAssets, @Nullable BigDecimal otherReceivables, @Nullable BigDecimal cryptoAssets, @Nullable BigDecimal cashAndCashEquivalents) {
                this.prepaymentsAndOtherShortTermAssets = prepaymentsAndOtherShortTermAssets;
                this.otherReceivables = otherReceivables;
                this.cryptoAssets = cryptoAssets;
                this.cashAndCashEquivalents = cashAndCashEquivalents;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CurrentAssets)) {
                    return false;
                }
                CurrentAssets other = (CurrentAssets)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Optional<BigDecimal> this$prepaymentsAndOtherShortTermAssets = this.getPrepaymentsAndOtherShortTermAssets();
                Optional<BigDecimal> other$prepaymentsAndOtherShortTermAssets = other.getPrepaymentsAndOtherShortTermAssets();
                if (this$prepaymentsAndOtherShortTermAssets == null ? other$prepaymentsAndOtherShortTermAssets != null : !((Object)this$prepaymentsAndOtherShortTermAssets).equals(other$prepaymentsAndOtherShortTermAssets)) {
                    return false;
                }
                Optional<BigDecimal> this$otherReceivables = this.getOtherReceivables();
                Optional<BigDecimal> other$otherReceivables = other.getOtherReceivables();
                if (this$otherReceivables == null ? other$otherReceivables != null : !((Object)this$otherReceivables).equals(other$otherReceivables)) {
                    return false;
                }
                Optional<BigDecimal> this$cryptoAssets = this.getCryptoAssets();
                Optional<BigDecimal> other$cryptoAssets = other.getCryptoAssets();
                if (this$cryptoAssets == null ? other$cryptoAssets != null : !((Object)this$cryptoAssets).equals(other$cryptoAssets)) {
                    return false;
                }
                Optional<BigDecimal> this$cashAndCashEquivalents = this.getCashAndCashEquivalents();
                Optional<BigDecimal> other$cashAndCashEquivalents = other.getCashAndCashEquivalents();
                return !(this$cashAndCashEquivalents == null ? other$cashAndCashEquivalents != null : !((Object)this$cashAndCashEquivalents).equals(other$cashAndCashEquivalents));
            }

            protected boolean canEqual(Object other) {
                return other instanceof CurrentAssets;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Optional<BigDecimal> $prepaymentsAndOtherShortTermAssets = this.getPrepaymentsAndOtherShortTermAssets();
                result = result * 59 + ($prepaymentsAndOtherShortTermAssets == null ? 43 : ((Object)$prepaymentsAndOtherShortTermAssets).hashCode());
                Optional<BigDecimal> $otherReceivables = this.getOtherReceivables();
                result = result * 59 + ($otherReceivables == null ? 43 : ((Object)$otherReceivables).hashCode());
                Optional<BigDecimal> $cryptoAssets = this.getCryptoAssets();
                result = result * 59 + ($cryptoAssets == null ? 43 : ((Object)$cryptoAssets).hashCode());
                Optional<BigDecimal> $cashAndCashEquivalents = this.getCashAndCashEquivalents();
                result = result * 59 + ($cashAndCashEquivalents == null ? 43 : ((Object)$cashAndCashEquivalents).hashCode());
                return result;
            }

            public String toString() {
                return "BalanceSheetData.Assets.CurrentAssets(prepaymentsAndOtherShortTermAssets=" + String.valueOf(this.getPrepaymentsAndOtherShortTermAssets()) + ", otherReceivables=" + String.valueOf(this.getOtherReceivables()) + ", cryptoAssets=" + String.valueOf(this.getCryptoAssets()) + ", cashAndCashEquivalents=" + String.valueOf(this.getCashAndCashEquivalents()) + ")";
            }

            public CurrentAssets() {
            }

            public static class CurrentAssetsBuilder {
                private BigDecimal prepaymentsAndOtherShortTermAssets;
                private BigDecimal otherReceivables;
                private BigDecimal cryptoAssets;
                private BigDecimal cashAndCashEquivalents;

                CurrentAssetsBuilder() {
                }

                public CurrentAssetsBuilder prepaymentsAndOtherShortTermAssets(@Nullable BigDecimal prepaymentsAndOtherShortTermAssets) {
                    this.prepaymentsAndOtherShortTermAssets = prepaymentsAndOtherShortTermAssets;
                    return this;
                }

                public CurrentAssetsBuilder otherReceivables(@Nullable BigDecimal otherReceivables) {
                    this.otherReceivables = otherReceivables;
                    return this;
                }

                public CurrentAssetsBuilder cryptoAssets(@Nullable BigDecimal cryptoAssets) {
                    this.cryptoAssets = cryptoAssets;
                    return this;
                }

                public CurrentAssetsBuilder cashAndCashEquivalents(@Nullable BigDecimal cashAndCashEquivalents) {
                    this.cashAndCashEquivalents = cashAndCashEquivalents;
                    return this;
                }

                public CurrentAssets build() {
                    return new CurrentAssets(this.prepaymentsAndOtherShortTermAssets, this.otherReceivables, this.cryptoAssets, this.cashAndCashEquivalents);
                }

                public String toString() {
                    return "BalanceSheetData.Assets.CurrentAssets.CurrentAssetsBuilder(prepaymentsAndOtherShortTermAssets=" + String.valueOf(this.prepaymentsAndOtherShortTermAssets) + ", otherReceivables=" + String.valueOf(this.otherReceivables) + ", cryptoAssets=" + String.valueOf(this.cryptoAssets) + ", cashAndCashEquivalents=" + String.valueOf(this.cashAndCashEquivalents) + ")";
                }
            }
        }

        public static class AssetsBuilder {
            private NonCurrentAssets nonCurrentAssets;
            private CurrentAssets currentAssets;

            AssetsBuilder() {
            }

            public AssetsBuilder nonCurrentAssets(@Nullable NonCurrentAssets nonCurrentAssets) {
                this.nonCurrentAssets = nonCurrentAssets;
                return this;
            }

            public AssetsBuilder currentAssets(@Nullable CurrentAssets currentAssets) {
                this.currentAssets = currentAssets;
                return this;
            }

            public Assets build() {
                return new Assets(this.nonCurrentAssets, this.currentAssets);
            }

            public String toString() {
                return "BalanceSheetData.Assets.AssetsBuilder(nonCurrentAssets=" + String.valueOf(this.nonCurrentAssets) + ", currentAssets=" + String.valueOf(this.currentAssets) + ")";
            }
        }
    }

    @Embeddable
    public static class Liabilities {
        @Nullable
        private NonCurrentLiabilities nonCurrentLiabilities;
        @Nullable
        private CurrentLiabilities currentLiabilities;

        public Optional<NonCurrentLiabilities> getNonCurrentLiabilities() {
            return Optional.ofNullable(this.nonCurrentLiabilities);
        }

        public Optional<CurrentLiabilities> getCurrentLiabilities() {
            return Optional.ofNullable(this.currentLiabilities);
        }

        public static LiabilitiesBuilder builder() {
            return new LiabilitiesBuilder();
        }

        public LiabilitiesBuilder toBuilder() {
            return new LiabilitiesBuilder().nonCurrentLiabilities(this.nonCurrentLiabilities).currentLiabilities(this.currentLiabilities);
        }

        public Liabilities(@Nullable NonCurrentLiabilities nonCurrentLiabilities, @Nullable CurrentLiabilities currentLiabilities) {
            this.nonCurrentLiabilities = nonCurrentLiabilities;
            this.currentLiabilities = currentLiabilities;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Liabilities)) {
                return false;
            }
            Liabilities other = (Liabilities)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<NonCurrentLiabilities> this$nonCurrentLiabilities = this.getNonCurrentLiabilities();
            Optional<NonCurrentLiabilities> other$nonCurrentLiabilities = other.getNonCurrentLiabilities();
            if (this$nonCurrentLiabilities == null ? other$nonCurrentLiabilities != null : !((Object)this$nonCurrentLiabilities).equals(other$nonCurrentLiabilities)) {
                return false;
            }
            Optional<CurrentLiabilities> this$currentLiabilities = this.getCurrentLiabilities();
            Optional<CurrentLiabilities> other$currentLiabilities = other.getCurrentLiabilities();
            return !(this$currentLiabilities == null ? other$currentLiabilities != null : !((Object)this$currentLiabilities).equals(other$currentLiabilities));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Liabilities;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<NonCurrentLiabilities> $nonCurrentLiabilities = this.getNonCurrentLiabilities();
            result = result * 59 + ($nonCurrentLiabilities == null ? 43 : ((Object)$nonCurrentLiabilities).hashCode());
            Optional<CurrentLiabilities> $currentLiabilities = this.getCurrentLiabilities();
            result = result * 59 + ($currentLiabilities == null ? 43 : ((Object)$currentLiabilities).hashCode());
            return result;
        }

        public String toString() {
            return "BalanceSheetData.Liabilities(nonCurrentLiabilities=" + String.valueOf(this.getNonCurrentLiabilities()) + ", currentLiabilities=" + String.valueOf(this.getCurrentLiabilities()) + ")";
        }

        public Liabilities() {
        }

        @Embeddable
        public static class NonCurrentLiabilities {
            @Nullable
            private BigDecimal provisions;

            public Optional<BigDecimal> getProvisions() {
                return Optional.ofNullable(this.provisions);
            }

            public static NonCurrentLiabilitiesBuilder builder() {
                return new NonCurrentLiabilitiesBuilder();
            }

            public NonCurrentLiabilitiesBuilder toBuilder() {
                return new NonCurrentLiabilitiesBuilder().provisions(this.provisions);
            }

            public NonCurrentLiabilities(@Nullable BigDecimal provisions) {
                this.provisions = provisions;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NonCurrentLiabilities)) {
                    return false;
                }
                NonCurrentLiabilities other = (NonCurrentLiabilities)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Optional<BigDecimal> this$provisions = this.getProvisions();
                Optional<BigDecimal> other$provisions = other.getProvisions();
                return !(this$provisions == null ? other$provisions != null : !((Object)this$provisions).equals(other$provisions));
            }

            protected boolean canEqual(Object other) {
                return other instanceof NonCurrentLiabilities;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Optional<BigDecimal> $provisions = this.getProvisions();
                result = result * 59 + ($provisions == null ? 43 : ((Object)$provisions).hashCode());
                return result;
            }

            public String toString() {
                return "BalanceSheetData.Liabilities.NonCurrentLiabilities(provisions=" + String.valueOf(this.getProvisions()) + ")";
            }

            public NonCurrentLiabilities() {
            }

            public static class NonCurrentLiabilitiesBuilder {
                private BigDecimal provisions;

                NonCurrentLiabilitiesBuilder() {
                }

                public NonCurrentLiabilitiesBuilder provisions(@Nullable BigDecimal provisions) {
                    this.provisions = provisions;
                    return this;
                }

                public NonCurrentLiabilities build() {
                    return new NonCurrentLiabilities(this.provisions);
                }

                public String toString() {
                    return "BalanceSheetData.Liabilities.NonCurrentLiabilities.NonCurrentLiabilitiesBuilder(provisions=" + String.valueOf(this.provisions) + ")";
                }
            }
        }

        @Embeddable
        public static class CurrentLiabilities {
            @Nullable
            private BigDecimal tradeAccountsPayables;
            @Nullable
            private BigDecimal otherShortTermLiabilities;
            @Nullable
            private BigDecimal accrualsAndShortTermProvisions;

            public Optional<BigDecimal> getTradeAccountsPayables() {
                return Optional.ofNullable(this.tradeAccountsPayables);
            }

            public Optional<BigDecimal> getOtherShortTermLiabilities() {
                return Optional.ofNullable(this.otherShortTermLiabilities);
            }

            public Optional<BigDecimal> getAccrualsAndShortTermProvisions() {
                return Optional.ofNullable(this.accrualsAndShortTermProvisions);
            }

            public static CurrentLiabilitiesBuilder builder() {
                return new CurrentLiabilitiesBuilder();
            }

            public CurrentLiabilitiesBuilder toBuilder() {
                return new CurrentLiabilitiesBuilder().tradeAccountsPayables(this.tradeAccountsPayables).otherShortTermLiabilities(this.otherShortTermLiabilities).accrualsAndShortTermProvisions(this.accrualsAndShortTermProvisions);
            }

            public CurrentLiabilities(@Nullable BigDecimal tradeAccountsPayables, @Nullable BigDecimal otherShortTermLiabilities, @Nullable BigDecimal accrualsAndShortTermProvisions) {
                this.tradeAccountsPayables = tradeAccountsPayables;
                this.otherShortTermLiabilities = otherShortTermLiabilities;
                this.accrualsAndShortTermProvisions = accrualsAndShortTermProvisions;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CurrentLiabilities)) {
                    return false;
                }
                CurrentLiabilities other = (CurrentLiabilities)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Optional<BigDecimal> this$tradeAccountsPayables = this.getTradeAccountsPayables();
                Optional<BigDecimal> other$tradeAccountsPayables = other.getTradeAccountsPayables();
                if (this$tradeAccountsPayables == null ? other$tradeAccountsPayables != null : !((Object)this$tradeAccountsPayables).equals(other$tradeAccountsPayables)) {
                    return false;
                }
                Optional<BigDecimal> this$otherShortTermLiabilities = this.getOtherShortTermLiabilities();
                Optional<BigDecimal> other$otherShortTermLiabilities = other.getOtherShortTermLiabilities();
                if (this$otherShortTermLiabilities == null ? other$otherShortTermLiabilities != null : !((Object)this$otherShortTermLiabilities).equals(other$otherShortTermLiabilities)) {
                    return false;
                }
                Optional<BigDecimal> this$accrualsAndShortTermProvisions = this.getAccrualsAndShortTermProvisions();
                Optional<BigDecimal> other$accrualsAndShortTermProvisions = other.getAccrualsAndShortTermProvisions();
                return !(this$accrualsAndShortTermProvisions == null ? other$accrualsAndShortTermProvisions != null : !((Object)this$accrualsAndShortTermProvisions).equals(other$accrualsAndShortTermProvisions));
            }

            protected boolean canEqual(Object other) {
                return other instanceof CurrentLiabilities;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Optional<BigDecimal> $tradeAccountsPayables = this.getTradeAccountsPayables();
                result = result * 59 + ($tradeAccountsPayables == null ? 43 : ((Object)$tradeAccountsPayables).hashCode());
                Optional<BigDecimal> $otherShortTermLiabilities = this.getOtherShortTermLiabilities();
                result = result * 59 + ($otherShortTermLiabilities == null ? 43 : ((Object)$otherShortTermLiabilities).hashCode());
                Optional<BigDecimal> $accrualsAndShortTermProvisions = this.getAccrualsAndShortTermProvisions();
                result = result * 59 + ($accrualsAndShortTermProvisions == null ? 43 : ((Object)$accrualsAndShortTermProvisions).hashCode());
                return result;
            }

            public String toString() {
                return "BalanceSheetData.Liabilities.CurrentLiabilities(tradeAccountsPayables=" + String.valueOf(this.getTradeAccountsPayables()) + ", otherShortTermLiabilities=" + String.valueOf(this.getOtherShortTermLiabilities()) + ", accrualsAndShortTermProvisions=" + String.valueOf(this.getAccrualsAndShortTermProvisions()) + ")";
            }

            public CurrentLiabilities() {
            }

            public static class CurrentLiabilitiesBuilder {
                private BigDecimal tradeAccountsPayables;
                private BigDecimal otherShortTermLiabilities;
                private BigDecimal accrualsAndShortTermProvisions;

                CurrentLiabilitiesBuilder() {
                }

                public CurrentLiabilitiesBuilder tradeAccountsPayables(@Nullable BigDecimal tradeAccountsPayables) {
                    this.tradeAccountsPayables = tradeAccountsPayables;
                    return this;
                }

                public CurrentLiabilitiesBuilder otherShortTermLiabilities(@Nullable BigDecimal otherShortTermLiabilities) {
                    this.otherShortTermLiabilities = otherShortTermLiabilities;
                    return this;
                }

                public CurrentLiabilitiesBuilder accrualsAndShortTermProvisions(@Nullable BigDecimal accrualsAndShortTermProvisions) {
                    this.accrualsAndShortTermProvisions = accrualsAndShortTermProvisions;
                    return this;
                }

                public CurrentLiabilities build() {
                    return new CurrentLiabilities(this.tradeAccountsPayables, this.otherShortTermLiabilities, this.accrualsAndShortTermProvisions);
                }

                public String toString() {
                    return "BalanceSheetData.Liabilities.CurrentLiabilities.CurrentLiabilitiesBuilder(tradeAccountsPayables=" + String.valueOf(this.tradeAccountsPayables) + ", otherShortTermLiabilities=" + String.valueOf(this.otherShortTermLiabilities) + ", accrualsAndShortTermProvisions=" + String.valueOf(this.accrualsAndShortTermProvisions) + ")";
                }
            }
        }

        public static class LiabilitiesBuilder {
            private NonCurrentLiabilities nonCurrentLiabilities;
            private CurrentLiabilities currentLiabilities;

            LiabilitiesBuilder() {
            }

            public LiabilitiesBuilder nonCurrentLiabilities(@Nullable NonCurrentLiabilities nonCurrentLiabilities) {
                this.nonCurrentLiabilities = nonCurrentLiabilities;
                return this;
            }

            public LiabilitiesBuilder currentLiabilities(@Nullable CurrentLiabilities currentLiabilities) {
                this.currentLiabilities = currentLiabilities;
                return this;
            }

            public Liabilities build() {
                return new Liabilities(this.nonCurrentLiabilities, this.currentLiabilities);
            }

            public String toString() {
                return "BalanceSheetData.Liabilities.LiabilitiesBuilder(nonCurrentLiabilities=" + String.valueOf(this.nonCurrentLiabilities) + ", currentLiabilities=" + String.valueOf(this.currentLiabilities) + ")";
            }
        }
    }

    @Embeddable
    public static class Capital {
        @Nullable
        private BigDecimal capital;
        @Nullable
        private BigDecimal profitForTheYear;
        @Nullable
        private BigDecimal resultsCarriedForward;

        public Optional<BigDecimal> getCapital() {
            return Optional.ofNullable(this.capital);
        }

        public Optional<BigDecimal> getProfitForTheYear() {
            return Optional.ofNullable(this.profitForTheYear);
        }

        public Optional<BigDecimal> getResultsCarriedForward() {
            return Optional.ofNullable(this.resultsCarriedForward);
        }

        public static CapitalBuilder builder() {
            return new CapitalBuilder();
        }

        public CapitalBuilder toBuilder() {
            return new CapitalBuilder().capital(this.capital).profitForTheYear(this.profitForTheYear).resultsCarriedForward(this.resultsCarriedForward);
        }

        public Capital(@Nullable BigDecimal capital, @Nullable BigDecimal profitForTheYear, @Nullable BigDecimal resultsCarriedForward) {
            this.capital = capital;
            this.profitForTheYear = profitForTheYear;
            this.resultsCarriedForward = resultsCarriedForward;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Capital)) {
                return false;
            }
            Capital other = (Capital)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<BigDecimal> this$capital = this.getCapital();
            Optional<BigDecimal> other$capital = other.getCapital();
            if (this$capital == null ? other$capital != null : !((Object)this$capital).equals(other$capital)) {
                return false;
            }
            Optional<BigDecimal> this$profitForTheYear = this.getProfitForTheYear();
            Optional<BigDecimal> other$profitForTheYear = other.getProfitForTheYear();
            if (this$profitForTheYear == null ? other$profitForTheYear != null : !((Object)this$profitForTheYear).equals(other$profitForTheYear)) {
                return false;
            }
            Optional<BigDecimal> this$resultsCarriedForward = this.getResultsCarriedForward();
            Optional<BigDecimal> other$resultsCarriedForward = other.getResultsCarriedForward();
            return !(this$resultsCarriedForward == null ? other$resultsCarriedForward != null : !((Object)this$resultsCarriedForward).equals(other$resultsCarriedForward));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Capital;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<BigDecimal> $capital = this.getCapital();
            result = result * 59 + ($capital == null ? 43 : ((Object)$capital).hashCode());
            Optional<BigDecimal> $profitForTheYear = this.getProfitForTheYear();
            result = result * 59 + ($profitForTheYear == null ? 43 : ((Object)$profitForTheYear).hashCode());
            Optional<BigDecimal> $resultsCarriedForward = this.getResultsCarriedForward();
            result = result * 59 + ($resultsCarriedForward == null ? 43 : ((Object)$resultsCarriedForward).hashCode());
            return result;
        }

        public String toString() {
            return "BalanceSheetData.Capital(capital=" + String.valueOf(this.getCapital()) + ", profitForTheYear=" + String.valueOf(this.getProfitForTheYear()) + ", resultsCarriedForward=" + String.valueOf(this.getResultsCarriedForward()) + ")";
        }

        public Capital() {
        }

        public static class CapitalBuilder {
            private BigDecimal capital;
            private BigDecimal profitForTheYear;
            private BigDecimal resultsCarriedForward;

            CapitalBuilder() {
            }

            public CapitalBuilder capital(@Nullable BigDecimal capital) {
                this.capital = capital;
                return this;
            }

            public CapitalBuilder profitForTheYear(@Nullable BigDecimal profitForTheYear) {
                this.profitForTheYear = profitForTheYear;
                return this;
            }

            public CapitalBuilder resultsCarriedForward(@Nullable BigDecimal resultsCarriedForward) {
                this.resultsCarriedForward = resultsCarriedForward;
                return this;
            }

            public Capital build() {
                return new Capital(this.capital, this.profitForTheYear, this.resultsCarriedForward);
            }

            public String toString() {
                return "BalanceSheetData.Capital.CapitalBuilder(capital=" + String.valueOf(this.capital) + ", profitForTheYear=" + String.valueOf(this.profitForTheYear) + ", resultsCarriedForward=" + String.valueOf(this.resultsCarriedForward) + ")";
            }
        }
    }

    public static class BalanceSheetDataBuilder {
        private Assets assets;
        private Liabilities liabilities;
        private Capital capital;

        BalanceSheetDataBuilder() {
        }

        public BalanceSheetDataBuilder assets(@Nullable Assets assets) {
            this.assets = assets;
            return this;
        }

        public BalanceSheetDataBuilder liabilities(@Nullable Liabilities liabilities) {
            this.liabilities = liabilities;
            return this;
        }

        public BalanceSheetDataBuilder capital(@Nullable Capital capital) {
            this.capital = capital;
            return this;
        }

        public BalanceSheetData build() {
            return new BalanceSheetData(this.assets, this.liabilities, this.capital);
        }

        public String toString() {
            return "BalanceSheetData.BalanceSheetDataBuilder(assets=" + String.valueOf(this.assets) + ", liabilities=" + String.valueOf(this.liabilities) + ", capital=" + String.valueOf(this.capital) + ")";
        }
    }
}

