/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_publisher.config;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.backend.api.BackendService;
import com.bloxbean.cardano.client.backend.api.DefaultUtxoSupplier;
import java.net.http.HttpClient;
import java.time.Clock;
import java.time.Duration;
import org.cardanofoundation.lob.app.blockchain_common.service_assistance.MetadataChecker;
import org.cardanofoundation.lob.app.blockchain_publisher.service.API1L1TransactionCreator;
import org.cardanofoundation.lob.app.blockchain_publisher.service.API1MetadataSerialiser;
import org.cardanofoundation.lob.app.blockchain_publisher.service.API3L1TransactionCreator;
import org.cardanofoundation.lob.app.blockchain_publisher.service.API3MetadataSerialiser;
import org.cardanofoundation.lob.app.blockchain_publisher.service.transation_submit.BackendServiceBlockchainTransactionSubmissionService;
import org.cardanofoundation.lob.app.blockchain_publisher.service.transation_submit.BlockchainTransactionSubmissionService;
import org.cardanofoundation.lob.app.blockchain_publisher.service.transation_submit.CardanoSubmitApiBlockchainTransactionSubmissionService;
import org.cardanofoundation.lob.app.blockchain_publisher.service.transation_submit.DefaultTransactionSubmissionService;
import org.cardanofoundation.lob.app.blockchain_publisher.service.transation_submit.TransactionSubmissionService;
import org.cardanofoundation.lob.app.blockchain_reader.BlockchainReaderPublicApiIF;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class TransactionSubmissionConfig {
    @Bean
    @Profile(value={"blockfrost", "dev--yaci-dev-kit", "test"})
    public BlockchainTransactionSubmissionService backendServiceTransactionSubmissionService(@Qualifier(value="yaci_blockfrost") BackendService backendService) {
        return new BackendServiceBlockchainTransactionSubmissionService(backendService);
    }

    @Bean
    @Profile(value={"blockfrost", "dev--yaci-dev-kit", "test"})
    public UtxoSupplier utxoSupplier(@Qualifier(value="yaci_blockfrost") BackendService backendService) {
        return new DefaultUtxoSupplier(backendService.getUtxoService());
    }

    @Bean
    public TransactionSubmissionService transactionSubmissionService(BlockchainTransactionSubmissionService trxSubmissionService, @Qualifier(value="yaci_blockfrost") BackendService backendService, UtxoSupplier utxoSupplier, Clock clock, @Value(value="${lob.transaction.submission.sleep.seconds:5}") int sleepTimeSeconds, @Value(value="${lob.transaction.submission.timeout.in.seconds:300}") int timeoutInSeconds) {
        return new DefaultTransactionSubmissionService(trxSubmissionService, backendService, utxoSupplier, clock, sleepTimeSeconds, timeoutInSeconds);
    }

    @Bean
    public API1L1TransactionCreator api1L1TransactionCreator(@Qualifier(value="yaci_blockfrost") BackendService backendService, API1MetadataSerialiser metadataSerialiser, BlockchainReaderPublicApiIF blockchainReaderPublicApi, @Qualifier(value="api1JsonSchemaMetadataChecker") MetadataChecker metadataChecker, Account organiserAccount, @Value(value="${l1.transaction.metadata_label:1447}") int metadataLabel, @Value(value="${l1.transaction.debug_store_output_tx:false}") boolean debugStoreOutputTx) {
        return new API1L1TransactionCreator(backendService, metadataSerialiser, blockchainReaderPublicApi, metadataChecker, organiserAccount, metadataLabel, debugStoreOutputTx);
    }

    @Bean
    public API3L1TransactionCreator api3L1TransactionCreator(@Qualifier(value="yaci_blockfrost") BackendService backendService, API3MetadataSerialiser metadataSerialiser, BlockchainReaderPublicApiIF blockchainReaderPublicApi, @Qualifier(value="api3JsonSchemaMetadataChecker") MetadataChecker metadataChecker, Account organiserAccount, @Value(value="${lob.l1.transaction.metadata_label:1447}") int metadataLabel, @Value(value="${lob.l1.transaction.debug_store_output_tx:false}") boolean debugStoreOutputTx) {
        return new API3L1TransactionCreator(backendService, metadataSerialiser, blockchainReaderPublicApi, metadataChecker, organiserAccount, metadataLabel, debugStoreOutputTx);
    }

    @Bean
    @Profile(value={"submit-api"})
    public BlockchainTransactionSubmissionService cardanoSummitTransactionSubmissionService(HttpClient httpClient, @Value(value="${lob.blockchain_publisher.tx.submit.url}") String cardanoSubmitApiUrl, @Value(value="${lob.blockchain_publisher.tx.submit.timeout.in.seconds}") int timeoutInSeconds, @Value(value="${lob.blockchain_publisher.tx.submit.api_key}") String apiKey) {
        return new CardanoSubmitApiBlockchainTransactionSubmissionService(cardanoSubmitApiUrl, apiKey, httpClient, timeoutInSeconds);
    }

    @Bean
    @Profile(value={"submit-api"})
    public HttpClient httpClient(@Value(value="${lob.blockchain_publisher.tx.submit.timeout.in.seconds:30}") int timeoutInSeconds) {
        return HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(timeoutInSeconds)).build();
    }
}

