/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_common.service_assistance;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.Set;
import org.cardanofoundation.lob.app.blockchain_common.service_assistance.MetadataChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class JsonSchemaMetadataChecker
implements MetadataChecker {
    private static final Logger log = LoggerFactory.getLogger(JsonSchemaMetadataChecker.class);
    private final ObjectMapper objectMapper;
    protected Resource metadataSchemaResource;
    protected boolean enableChecker;

    @PostConstruct
    public void init() {
        log.info("JsonSchemaMetadataChecker, metadata validation enabled: {}, schema found:{}", (Object)this.enableChecker, (Object)this.metadataSchemaResource.exists());
    }

    @Override
    public boolean checkTransactionMetadata(String json) {
        if (!this.enableChecker) {
            log.warn("Metadata validation is disabled, not recommended in production / mainnet!");
            return true;
        }
        try {
            JsonNode jsonObject = this.objectMapper.readTree(json);
            JsonSchemaFactory jsonSchemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
            JsonSchema schema = jsonSchemaFactory.getSchema(this.metadataSchemaResource.getInputStream());
            Set validationResult = schema.validate(jsonObject);
            if (!validationResult.isEmpty()) {
                log.error("Metadata validation failed: {}", (Object)validationResult);
                return false;
            }
            return true;
        }
        catch (IOException e) {
            log.error("Error serializing metadata to cbor", (Throwable)e);
            return false;
        }
    }

    public JsonSchemaMetadataChecker(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setMetadataSchemaResource(Resource metadataSchemaResource) {
        this.metadataSchemaResource = metadataSchemaResource;
    }

    public void setEnableChecker(boolean enableChecker) {
        this.enableChecker = enableChecker;
    }
}

