/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_common.domain;

import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import org.cardanofoundation.lob.app.blockchain_common.domain.CardanoNetwork;

public class ChainTip {
    private long absoluteSlot;
    private String blockHash;
    private Optional<Integer> epochNo;
    @NotNull
    private CardanoNetwork network;
    private boolean isSynced;

    private static Optional<Integer> $default$epochNo() {
        return Optional.empty();
    }

    public static ChainTipBuilder builder() {
        return new ChainTipBuilder();
    }

    public ChainTip(long absoluteSlot, String blockHash, Optional<Integer> epochNo, CardanoNetwork network, boolean isSynced) {
        this.absoluteSlot = absoluteSlot;
        this.blockHash = blockHash;
        this.epochNo = epochNo;
        this.network = network;
        this.isSynced = isSynced;
    }

    public ChainTip() {
        this.epochNo = ChainTip.$default$epochNo();
    }

    public long getAbsoluteSlot() {
        return this.absoluteSlot;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public Optional<Integer> getEpochNo() {
        return this.epochNo;
    }

    public CardanoNetwork getNetwork() {
        return this.network;
    }

    public boolean isSynced() {
        return this.isSynced;
    }

    public void setAbsoluteSlot(long absoluteSlot) {
        this.absoluteSlot = absoluteSlot;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public void setEpochNo(Optional<Integer> epochNo) {
        this.epochNo = epochNo;
    }

    public void setNetwork(CardanoNetwork network) {
        this.network = network;
    }

    public void setSynced(boolean isSynced) {
        this.isSynced = isSynced;
    }

    public static class ChainTipBuilder {
        private long absoluteSlot;
        private String blockHash;
        private boolean epochNo$set;
        private Optional<Integer> epochNo$value;
        private CardanoNetwork network;
        private boolean isSynced;

        ChainTipBuilder() {
        }

        public ChainTipBuilder absoluteSlot(long absoluteSlot) {
            this.absoluteSlot = absoluteSlot;
            return this;
        }

        public ChainTipBuilder blockHash(String blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        public ChainTipBuilder epochNo(Optional<Integer> epochNo) {
            this.epochNo$value = epochNo;
            this.epochNo$set = true;
            return this;
        }

        public ChainTipBuilder network(CardanoNetwork network) {
            this.network = network;
            return this;
        }

        public ChainTipBuilder isSynced(boolean isSynced) {
            this.isSynced = isSynced;
            return this;
        }

        public ChainTip build() {
            Optional<Integer> epochNo$value = this.epochNo$value;
            if (!this.epochNo$set) {
                epochNo$value = ChainTip.$default$epochNo();
            }
            return new ChainTip(this.absoluteSlot, this.blockHash, epochNo$value, this.network, this.isSynced);
        }

        public String toString() {
            return "ChainTip.ChainTipBuilder(absoluteSlot=" + this.absoluteSlot + ", blockHash=" + this.blockHash + ", epochNo$value=" + String.valueOf(this.epochNo$value) + ", network=" + String.valueOf((Object)this.network) + ", isSynced=" + this.isSynced + ")";
        }
    }
}

