/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_common.domain;

import org.cardanofoundation.lob.app.blockchain_common.domain.CardanoNetwork;
import org.cardanofoundation.lob.app.blockchain_common.domain.FinalityScore;

public class OnChainTxDetails {
    private String transactionHash;
    private String blockHash;
    private long absoluteSlot;
    private long slotConfirmations;
    private FinalityScore finalityScore;
    private CardanoNetwork network;

    public static OnChainTxDetailsBuilder builder() {
        return new OnChainTxDetailsBuilder();
    }

    public OnChainTxDetails(String transactionHash, String blockHash, long absoluteSlot, long slotConfirmations, FinalityScore finalityScore, CardanoNetwork network) {
        this.transactionHash = transactionHash;
        this.blockHash = blockHash;
        this.absoluteSlot = absoluteSlot;
        this.slotConfirmations = slotConfirmations;
        this.finalityScore = finalityScore;
        this.network = network;
    }

    public String getTransactionHash() {
        return this.transactionHash;
    }

    public String getBlockHash() {
        return this.blockHash;
    }

    public long getAbsoluteSlot() {
        return this.absoluteSlot;
    }

    public long getSlotConfirmations() {
        return this.slotConfirmations;
    }

    public FinalityScore getFinalityScore() {
        return this.finalityScore;
    }

    public CardanoNetwork getNetwork() {
        return this.network;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public void setBlockHash(String blockHash) {
        this.blockHash = blockHash;
    }

    public void setAbsoluteSlot(long absoluteSlot) {
        this.absoluteSlot = absoluteSlot;
    }

    public void setSlotConfirmations(long slotConfirmations) {
        this.slotConfirmations = slotConfirmations;
    }

    public void setFinalityScore(FinalityScore finalityScore) {
        this.finalityScore = finalityScore;
    }

    public void setNetwork(CardanoNetwork network) {
        this.network = network;
    }

    public OnChainTxDetails() {
    }

    public String toString() {
        return "OnChainTxDetails(transactionHash=" + this.getTransactionHash() + ", blockHash=" + this.getBlockHash() + ", absoluteSlot=" + this.getAbsoluteSlot() + ", slotConfirmations=" + this.getSlotConfirmations() + ", finalityScore=" + String.valueOf((Object)this.getFinalityScore()) + ", network=" + String.valueOf((Object)this.getNetwork()) + ")";
    }

    public static class OnChainTxDetailsBuilder {
        private String transactionHash;
        private String blockHash;
        private long absoluteSlot;
        private long slotConfirmations;
        private FinalityScore finalityScore;
        private CardanoNetwork network;

        OnChainTxDetailsBuilder() {
        }

        public OnChainTxDetailsBuilder transactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        public OnChainTxDetailsBuilder blockHash(String blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        public OnChainTxDetailsBuilder absoluteSlot(long absoluteSlot) {
            this.absoluteSlot = absoluteSlot;
            return this;
        }

        public OnChainTxDetailsBuilder slotConfirmations(long slotConfirmations) {
            this.slotConfirmations = slotConfirmations;
            return this;
        }

        public OnChainTxDetailsBuilder finalityScore(FinalityScore finalityScore) {
            this.finalityScore = finalityScore;
            return this;
        }

        public OnChainTxDetailsBuilder network(CardanoNetwork network) {
            this.network = network;
            return this;
        }

        public OnChainTxDetails build() {
            return new OnChainTxDetails(this.transactionHash, this.blockHash, this.absoluteSlot, this.slotConfirmations, this.finalityScore, this.network);
        }

        public String toString() {
            return "OnChainTxDetails.OnChainTxDetailsBuilder(transactionHash=" + this.transactionHash + ", blockHash=" + this.blockHash + ", absoluteSlot=" + this.absoluteSlot + ", slotConfirmations=" + this.slotConfirmations + ", finalityScore=" + String.valueOf((Object)this.finalityScore) + ", network=" + String.valueOf((Object)this.network) + ")";
        }
    }
}

