/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.blockchain_common.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.cardanofoundation.lob.app.blockchain_common.service_assistance.JsonSchemaMetadataChecker;
import org.cardanofoundation.lob.app.blockchain_common.service_assistance.MetadataChecker;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
public class BlockchainCommonConfig {
    @Value(value="${lob.l1.transaction.metadata.validation.enable:true}")
    private boolean enableChecker;

    @Bean
    public MetadataChecker api1JsonSchemaMetadataChecker(ObjectMapper objectMapper, @Value(value="classpath:api1_lob_blockchain_transaction_metadata_schema.json") Resource metadataSchemaResource) {
        JsonSchemaMetadataChecker checker = new JsonSchemaMetadataChecker(objectMapper);
        checker.setMetadataSchemaResource(metadataSchemaResource);
        checker.setEnableChecker(this.enableChecker);
        return checker;
    }

    @Bean
    public MetadataChecker api3JsonSchemaMetadataChecker(ObjectMapper objectMapper, @Value(value="classpath:api3_lob_blockchain_transaction_metadata_schema.json") Resource metadataSchemaResource) {
        JsonSchemaMetadataChecker checker = new JsonSchemaMetadataChecker(objectMapper);
        checker.setMetadataSchemaResource(metadataSchemaResource);
        checker.setEnableChecker(this.enableChecker);
        return checker;
    }
}

