/*
 * Decompiled with CFR 0.152.
 */
package org.canedata.module.ehcache;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import org.canedata.cache.Cache;
import org.canedata.cache.CacheProvider;
import org.canedata.core.logging.LoggerFactory;
import org.canedata.core.util.StringUtils;
import org.canedata.logging.Logger;
import org.canedata.module.ehcache.EhcacheCacheAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcacheProvider
implements CacheProvider {
    private static final Logger logger = LoggerFactory.getLogger(EhcacheProvider.class);
    private final Map<String, Cache> caches = Collections.synchronizedMap(new HashMap(1));
    protected String configFile = null;
    private String cacheName = "default";
    private static final String VENDOR = "Cane team";
    private static final String NAME = "Cache provider for ehcache";
    private final Map<String, Object> extras = new HashMap<String, Object>();
    protected static CacheManager CACHE_MANAGER;

    public EhcacheProvider() {
    }

    public EhcacheProvider(String cacheName) {
        this.setCacheName(cacheName);
    }

    public EhcacheProvider(String cacheName, String config) {
        this.setCacheName(cacheName);
        this.setConfigFile(config);
    }

    public String getName() {
        return NAME;
    }

    public String getVendor() {
        return VENDOR;
    }

    public int getVersion() {
        return 1;
    }

    public Map<String, Object> getExtras() {
        return this.extras;
    }

    public Object getExtra(String key) {
        return this.extras.get(key);
    }

    public Cache getCache(String schema) {
        return this.getCache(schema, null);
    }

    public Cache getCache(String schema, Map<String, Object> strategies) {
        Cache cache;
        if (logger.isDebug()) {
            logger.debug("Get cache from EhCacheManager, schema {0} ignored use {1}.", new Object[]{schema, this.getCacheName()});
        }
        if (strategies != null && !strategies.isEmpty()) {
            this.extras.putAll(strategies);
        }
        if (null == (cache = this.caches.get(schema))) {
            net.sf.ehcache.Cache ehcache = this.getManager().getCache(this.matchCacheName(schema));
            if (null == ehcache) {
                throw new RuntimeException("Don't get Ehcache from " + this.getConfigFile() + " by " + this.getCacheName() + ".");
            }
            cache = new EhcacheCacheAdaptor(ehcache);
            this.caches.put(schema, cache);
        }
        return cache;
    }

    private String matchCacheName(String schema) {
        String[] ns;
        if (StringUtils.isBlank((String)schema)) {
            return this.getCacheName();
        }
        for (String n : ns = this.getManager().getCacheNames()) {
            if (!schema.matches(n)) continue;
            if (logger.isDebug()) {
                logger.debug("Schema {0} matched cache named {1}.", new Object[]{schema, n});
            }
            return n;
        }
        if (logger.isDebug()) {
            logger.debug("Schema {0} not matched cache, use default cache {1}.", new Object[]{schema, this.getCacheName()});
        }
        return this.getCacheName();
    }

    private CacheManager getManager() {
        if (null == CACHE_MANAGER) {
            CACHE_MANAGER = StringUtils.isBlank((String)this.getConfigFile()) ? CacheManager.create((URL)this.getClass().getClassLoader().getResource("ehcache.xml")) : CacheManager.create((URL)this.getClass().getClassLoader().getResource(this.getConfigFile()));
        }
        return CACHE_MANAGER;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }
}

