/*
 * Decompiled with CFR 0.152.
 */
package org.canedata.module.ehcache;

import net.sf.ehcache.Element;
import org.canedata.cache.Cache;
import org.canedata.cache.Cacheable;
import org.canedata.core.logging.LoggerFactory;
import org.canedata.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcacheCacheAdaptor
implements Cache {
    protected Logger logger = LoggerFactory.getLogger(EhcacheCacheAdaptor.class);
    protected net.sf.ehcache.Cache wrapped = null;

    public EhcacheCacheAdaptor(net.sf.ehcache.Cache wrap) {
        if (null == wrap) {
            throw new RuntimeException("Don't get cache instance of Ehcache.");
        }
        if (this.logger.isDebug()) {
            this.logger.debug("Create Cache instance {0}.", new Object[]{wrap.hashCode()});
        }
        this.wrapped = wrap;
    }

    public void cache(Cacheable target) {
        this.wrapped.put(new Element(target.getKey(), (Object)target.onCaching()));
    }

    public <T> T restore(Object key) {
        Element e = this.wrapped.get(key);
        if (null == e) {
            return null;
        }
        Cacheable t = (Cacheable)e.getObjectValue();
        return (T)t.onRestored();
    }

    public void remove(Object key) {
        this.wrapped.remove(key);
    }

    public boolean isAlive(Object key) {
        if (this.logger.isDebug()) {
            this.logger.debug("#isAlive, key is {0}, keyInCache is {1}.", new Object[]{key, this.wrapped.isKeyInCache(key)});
        }
        if (!this.wrapped.isKeyInCache(key)) {
            return false;
        }
        Element o = this.wrapped.get(key);
        if (null == o) {
            return false;
        }
        return !o.isExpired();
    }
}

