/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.restdoclet.writer.swagger.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.calrissian.restdoclet.util.CommonUtils;

public class ResourceListing {
    private final String swaggerVersion;
    private final String apiVersion;
    private Collection<Map<String, String>> apis;
    private Map<String, String> info;

    public ResourceListing(String swaggerVersion, String apiVersion, String title) {
        this.swaggerVersion = swaggerVersion;
        this.apiVersion = apiVersion;
        this.apis = new ArrayList<Map<String, String>>();
        this.info = new LinkedHashMap<String, String>(1);
        if (!CommonUtils.isEmpty(title)) {
            this.info.put("title", title);
        }
    }

    public void addApi(String path, String description) {
        if (CommonUtils.isEmpty(path)) {
            return;
        }
        LinkedHashMap<String, String> api = new LinkedHashMap<String, String>(2);
        api.put("path", path);
        api.put("description", CommonUtils.isEmpty(description) ? "" : description);
        this.apis.add(api);
    }

    public String getSwaggerVersion() {
        return this.swaggerVersion;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Collection<Map<String, String>> getApis() {
        return this.apis;
    }

    public Map<String, String> getInfo() {
        return this.info;
    }
}

