/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.restdoclet.writer.swagger;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.ParameterizedType;
import com.sun.javadoc.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.calrissian.restdoclet.util.CommonUtils;

class TypeUtils {
    TypeUtils() {
    }

    public static String dataType(Type type) {
        if (type == null) {
            return null;
        }
        if (TypeUtils.isContainer(type)) {
            if (TypeUtils.isType(type.asClassDoc(), Set.class)) {
                return "Set[" + TypeUtils.internalContainerType(type) + "]";
            }
            return "List[" + TypeUtils.internalContainerType(type) + "]";
        }
        return TypeUtils.basicType(type);
    }

    public static boolean isContainer(Type type) {
        if (type.dimension() != null && !type.dimension().isEmpty()) {
            return true;
        }
        return TypeUtils.isType(type.asClassDoc(), Iterable.class);
    }

    public static String internalContainerType(Type type) {
        Type[] paramTypes;
        if (type.dimension() != null && !type.dimension().isEmpty()) {
            return TypeUtils.basicType(type);
        }
        ParameterizedType pType = type.asParameterizedType();
        if (pType != null && !CommonUtils.isEmpty(paramTypes = ((ParameterizedType)type).typeArguments())) {
            return TypeUtils.basicType(paramTypes[0]);
        }
        return "Object";
    }

    public static String basicType(Type type) {
        if (type == null) {
            return "void";
        }
        if (type.isPrimitive()) {
            return type.qualifiedTypeName();
        }
        String name = type.qualifiedTypeName();
        if (name.equals(String.class.getName())) {
            return "string";
        }
        if (name.equals(Boolean.class.getName())) {
            return "boolean";
        }
        if (name.equals(Integer.class.getName())) {
            return "int";
        }
        if (name.equals(Long.class.getName())) {
            return "long";
        }
        if (name.equals(Float.class.getName())) {
            return "float";
        }
        if (name.equals(Double.class.getName())) {
            return "double";
        }
        if (name.equals(Byte.class.getName())) {
            return "byte";
        }
        if (name.equals(Date.class.getName())) {
            return "Date";
        }
        if (!CommonUtils.isEmpty(type.asClassDoc().enumConstants())) {
            return "string";
        }
        return "object";
    }

    public static Collection<String> allowableValues(Type type) {
        if (type == null || type.asClassDoc() == null) {
            return Collections.emptyList();
        }
        FieldDoc[] fields = type.asClassDoc().enumConstants();
        if (CommonUtils.isEmpty(fields)) {
            return Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>(fields.length);
        for (FieldDoc field : fields) {
            values.add(field.name());
        }
        return values;
    }

    private static <T> boolean isType(ClassDoc classDoc, Class<T> targetClazz) {
        if (classDoc == null) {
            return false;
        }
        if (classDoc.qualifiedTypeName().equals(targetClazz.getName())) {
            return true;
        }
        if (TypeUtils.isType(classDoc.superclass(), targetClazz)) {
            return true;
        }
        for (ClassDoc iface : classDoc.interfaces()) {
            if (!TypeUtils.isType(iface, targetClazz)) continue;
            return true;
        }
        return false;
    }
}

