/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.restdoclet.writer.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.calrissian.restdoclet.Configuration;
import org.calrissian.restdoclet.model.ClassDescriptor;
import org.calrissian.restdoclet.model.Endpoint;
import org.calrissian.restdoclet.model.PathVar;
import org.calrissian.restdoclet.model.QueryParam;
import org.calrissian.restdoclet.model.RequestBody;
import org.calrissian.restdoclet.util.CommonUtils;
import org.calrissian.restdoclet.writer.Writer;
import org.calrissian.restdoclet.writer.swagger.TypeUtils;
import org.calrissian.restdoclet.writer.swagger.model.Api;
import org.calrissian.restdoclet.writer.swagger.model.ApiListing;
import org.calrissian.restdoclet.writer.swagger.model.Operation;
import org.calrissian.restdoclet.writer.swagger.model.Parameter;
import org.calrissian.restdoclet.writer.swagger.model.ResourceListing;

public class SwaggerWriter
implements Writer {
    public static final String OUTPUT_OPTION_NAME = "swagger";
    private static final String SWAGGER_DEFAULT_HTML = "swagger/index.html";
    private static final String SWAGGER_CALLABLE_HTML = "swagger/index-callable.html";
    private static final String SWAGGER_UI_ARTIFACT = "swagger/swagger-ui.zip";
    private static final String SWAGGER_VERSION = "1.2";
    private static final String RESOURCE_DOC = "./api-docs";
    private static final String API_DOC_DIR = "apis";
    private static ObjectMapper mapper = new ObjectMapper().configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);

    @Override
    public void write(Collection<ClassDescriptor> classDescriptors, Configuration config) throws IOException {
        LinkedHashMap<String, Collection<Endpoint>> resources = new LinkedHashMap<String, Collection<Endpoint>>();
        for (ClassDescriptor classDescriptor : classDescriptors) {
            for (Endpoint endpoint : classDescriptor.getEndpoints()) {
                String resourceName = SwaggerWriter.getResource(classDescriptor.getContextPath(), endpoint);
                if (resources.containsKey(resourceName)) {
                    ((Collection)resources.get(resourceName)).add(endpoint);
                    continue;
                }
                ArrayList<Endpoint> tmp = new ArrayList<Endpoint>();
                tmp.add(endpoint);
                resources.put(resourceName, tmp);
            }
        }
        SwaggerWriter.writeResource(resources, config);
        SwaggerWriter.copyIndex(config);
        SwaggerWriter.copySwagger();
    }

    private static void writeResource(Map<String, Collection<Endpoint>> resources, Configuration config) throws IOException {
        ResourceListing resourceListing = new ResourceListing(SWAGGER_VERSION, config.getApiVersion(), config.getDocumentTitle());
        for (Map.Entry<String, Collection<Endpoint>> entry : resources.entrySet()) {
            resourceListing.addApi("/../apis" + entry.getKey(), "");
            SwaggerWriter.writeApi(entry.getKey(), entry.getValue(), config);
        }
        mapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)new FileOutputStream(RESOURCE_DOC), (Object)resourceListing);
    }

    private static void writeApi(String resource, Collection<Endpoint> endpoints, Configuration config) throws IOException {
        Map<String, Collection<Endpoint>> pathGroups = SwaggerWriter.groupPaths(endpoints);
        File apiFile = new File("./apis", resource);
        apiFile.getParentFile().mkdirs();
        ArrayList<Api> apis = new ArrayList<Api>(pathGroups.size());
        for (Map.Entry<String, Collection<Endpoint>> entry : pathGroups.entrySet()) {
            apis.add(new Api(entry.getKey(), "", SwaggerWriter.getOperations(entry.getValue())));
        }
        mapper.writerWithDefaultPrettyPrinter().writeValue((OutputStream)new FileOutputStream(apiFile), (Object)new ApiListing(SWAGGER_VERSION, config.getPath(), resource, config.getApiVersion(), apis));
    }

    private static Collection<Operation> getOperations(Collection<Endpoint> endpoints) {
        ArrayList<Operation> operations = new ArrayList<Operation>(endpoints.size());
        for (Endpoint endpoint : endpoints) {
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            for (PathVar pathVar : endpoint.getPathVars()) {
                params.add(SwaggerWriter.getParameter(pathVar));
            }
            for (QueryParam queryParam : endpoint.getQueryParams()) {
                params.add(SwaggerWriter.getParameter(queryParam));
            }
            if (endpoint.getRequestBody() != null) {
                params.add(SwaggerWriter.getParameter(endpoint.getRequestBody()));
            }
            operations.add(new Operation(endpoint.getHttpMethod(), "nickname", endpoint.getShortDescription(), endpoint.getDescription(), TypeUtils.dataType(endpoint.getType()), endpoint.getProduces(), endpoint.getConsumes(), params));
        }
        return operations;
    }

    private static Parameter getParameter(PathVar pathVar) {
        return new Parameter("path", pathVar.getName(), pathVar.getDescription(), TypeUtils.basicType(pathVar.getType()), null, true, false, TypeUtils.allowableValues(pathVar.getType()));
    }

    private static Parameter getParameter(QueryParam queryParam) {
        boolean container = TypeUtils.isContainer(queryParam.getType());
        return new Parameter("query", queryParam.getName(), queryParam.getDescription(), container ? TypeUtils.internalContainerType(queryParam.getType()) : TypeUtils.basicType(queryParam.getType()), null, queryParam.isRequired(), container, TypeUtils.allowableValues(queryParam.getType()));
    }

    private static Parameter getParameter(RequestBody requestBody) {
        return new Parameter("body", requestBody.getName(), requestBody.getDescription(), TypeUtils.dataType(requestBody.getType()), null, true, false, TypeUtils.allowableValues(requestBody.getType()));
    }

    private static Map<String, Collection<Endpoint>> groupPaths(Collection<Endpoint> endpoints) {
        LinkedHashMap<String, Collection<Endpoint>> paths = new LinkedHashMap<String, Collection<Endpoint>>();
        for (Endpoint endpoint : endpoints) {
            if (paths.containsKey(endpoint.getPath())) {
                ((Collection)paths.get(endpoint.getPath())).add(endpoint);
                continue;
            }
            ArrayList<Endpoint> tmp = new ArrayList<Endpoint>();
            tmp.add(endpoint);
            paths.put(endpoint.getPath(), tmp);
        }
        return paths;
    }

    private static String getResource(String contextPath, Endpoint endpoint) {
        String tmp;
        if (endpoint == null || CommonUtils.isEmpty(endpoint.getPath())) {
            return "/";
        }
        contextPath = !(tmp = CommonUtils.fixPath(endpoint.getPath())).startsWith(contextPath = CommonUtils.fixPath(contextPath)) ? "" : contextPath;
        if ((tmp = tmp.substring(contextPath.length())).indexOf("/", 1) > 0) {
            tmp = tmp.substring(0, tmp.indexOf("/", 1));
        }
        return contextPath + tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyIndex(Configuration config) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = config.isCallable() ? Thread.currentThread().getContextClassLoader().getResourceAsStream(SWAGGER_CALLABLE_HTML) : Thread.currentThread().getContextClassLoader().getResourceAsStream(SWAGGER_DEFAULT_HTML);
            out = new FileOutputStream(new File(".", "index.html"));
            CommonUtils.copy(in, out);
        }
        catch (Throwable throwable) {
            CommonUtils.close(in, out);
            throw throwable;
        }
        CommonUtils.close(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copySwagger() throws IOException {
        ZipInputStream swaggerZip = null;
        Object out = null;
        try {
            ZipEntry entry;
            swaggerZip = new ZipInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream(SWAGGER_UI_ARTIFACT));
            while ((entry = swaggerZip.getNextEntry()) != null) {
                File swaggerFile = new File(".", entry.getName());
                if (entry.isDirectory()) {
                    if (swaggerFile.isDirectory() || swaggerFile.mkdirs()) continue;
                    throw new RuntimeException("Unable to create directory: " + swaggerFile);
                }
                CommonUtils.copy(swaggerZip, new FileOutputStream(swaggerFile));
            }
        }
        catch (Throwable throwable) {
            CommonUtils.close(swaggerZip, out);
            throw throwable;
        }
        CommonUtils.close(swaggerZip, out);
    }
}

