/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.restdoclet.collector;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.calrissian.restdoclet.collector.Collector;
import org.calrissian.restdoclet.collector.EndpointMapping;
import org.calrissian.restdoclet.model.ClassDescriptor;
import org.calrissian.restdoclet.model.Endpoint;
import org.calrissian.restdoclet.model.PathVar;
import org.calrissian.restdoclet.model.QueryParam;
import org.calrissian.restdoclet.model.RequestBody;
import org.calrissian.restdoclet.util.CommonUtils;
import org.calrissian.restdoclet.util.TagUtils;

public abstract class AbstractCollector
implements Collector {
    protected abstract boolean shouldIgnoreClass(ClassDoc var1);

    protected abstract boolean shouldIgnoreMethod(MethodDoc var1);

    protected abstract EndpointMapping getEndpointMapping(ProgramElementDoc var1);

    protected abstract Collection<PathVar> generatePathVars(MethodDoc var1);

    protected abstract Collection<QueryParam> generateQueryParams(MethodDoc var1);

    protected abstract RequestBody generateRequestBody(MethodDoc var1);

    @Override
    public Collection<ClassDescriptor> getDescriptors(RootDoc rootDoc) {
        ArrayList<ClassDescriptor> classDescriptors = new ArrayList<ClassDescriptor>();
        for (ClassDoc classDoc : rootDoc.classes()) {
            ClassDescriptor descriptor = this.getClassDescriptor(classDoc);
            if (descriptor == null || CommonUtils.isEmpty(descriptor.getEndpoints())) continue;
            classDescriptors.add(descriptor);
        }
        return classDescriptors;
    }

    protected ClassDescriptor getClassDescriptor(ClassDoc classDoc) {
        if (!CommonUtils.isEmpty(classDoc.tags("ignore")) || this.shouldIgnoreClass(classDoc)) {
            return null;
        }
        String contextPath = this.getContextPath(classDoc);
        Collection<Endpoint> endpoints = this.getAllEndpoints(contextPath, classDoc, this.getEndpointMapping((ProgramElementDoc)classDoc));
        if (CommonUtils.isEmpty(endpoints)) {
            return null;
        }
        String name = this.getClassName(classDoc);
        String description = this.getClassDescription(classDoc);
        return new ClassDescriptor(name == null ? "" : name, contextPath == null ? "" : contextPath, endpoints, description == null ? "" : description);
    }

    protected Collection<Endpoint> getAllEndpoints(String contextPath, ClassDoc classDoc, EndpointMapping classMapping) {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (MethodDoc method : classDoc.methods(true)) {
            endpoints.addAll(this.getEndpoint(contextPath, classMapping, method));
        }
        if (classDoc.superclass() != null) {
            endpoints.addAll(this.getAllEndpoints(contextPath, classDoc.superclass(), classMapping));
        }
        return endpoints;
    }

    protected Collection<Endpoint> getEndpoint(String contextPath, EndpointMapping classMapping, MethodDoc method) {
        if (!CommonUtils.isEmpty(method.tags("ignore")) || this.shouldIgnoreMethod(method)) {
            return Collections.emptyList();
        }
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        EndpointMapping methodMapping = this.getEndpointMapping((ProgramElementDoc)method);
        Collection<String> paths = this.resolvePaths(contextPath, classMapping, methodMapping);
        Collection<String> httpMethods = this.resolveHttpMethods(classMapping, methodMapping);
        Collection<String> consumes = this.resolveConsumesInfo(classMapping, methodMapping);
        Collection<String> produces = this.resolvesProducesInfo(classMapping, methodMapping);
        Collection<PathVar> pathVars = this.generatePathVars(method);
        Collection<QueryParam> queryParams = this.generateQueryParams(method);
        RequestBody requestBody = this.generateRequestBody(method);
        for (String httpMethod : httpMethods) {
            for (String path : paths) {
                endpoints.add(new Endpoint(path, httpMethod, queryParams, pathVars, requestBody, consumes, produces, method.commentText(), TagUtils.firstSentence((Doc)method), method.returnType()));
            }
        }
        return endpoints;
    }

    protected String getContextPath(ClassDoc classDoc) {
        if (!CommonUtils.isEmpty(classDoc.tags("contextPath"))) {
            return classDoc.tags("contextPath")[0].text();
        }
        return "";
    }

    protected String getClassName(ClassDoc classDoc) {
        if (!CommonUtils.isEmpty(classDoc.tags("name"))) {
            return classDoc.tags("name")[0].text();
        }
        return classDoc.typeName();
    }

    protected String getClassDescription(ClassDoc classDoc) {
        return classDoc.commentText();
    }

    protected Collection<String> resolvePaths(String contextPath, EndpointMapping classMapping, EndpointMapping methodMapping) {
        contextPath = contextPath == null ? "" : contextPath;
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        if (CommonUtils.isEmpty(classMapping.getPaths())) {
            for (String path : methodMapping.getPaths()) {
                paths.add(CommonUtils.fixPath(contextPath + path));
            }
        } else if (CommonUtils.isEmpty(methodMapping.getPaths())) {
            for (String path : classMapping.getPaths()) {
                paths.add(CommonUtils.fixPath(contextPath + path));
            }
        } else {
            for (String defaultPath : classMapping.getPaths()) {
                for (String path : methodMapping.getPaths()) {
                    paths.add(CommonUtils.fixPath(contextPath + defaultPath + path));
                }
            }
        }
        return paths;
    }

    protected Collection<String> resolveHttpMethods(EndpointMapping classMapping, EndpointMapping methodMapping) {
        return CommonUtils.firstNonEmpty(methodMapping.getHttpMethods(), classMapping.getHttpMethods());
    }

    protected Collection<String> resolveConsumesInfo(EndpointMapping classMapping, EndpointMapping methodMapping) {
        return CommonUtils.firstNonEmpty(methodMapping.getConsumes(), classMapping.getConsumes());
    }

    protected Collection<String> resolvesProducesInfo(EndpointMapping classMapping, EndpointMapping methodMapping) {
        return CommonUtils.firstNonEmpty(methodMapping.getProduces(), classMapping.getProduces());
    }
}

