/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.restdoclet;

import com.sun.javadoc.Doclet;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.calrissian.restdoclet.Configuration;
import org.calrissian.restdoclet.collector.Collector;
import org.calrissian.restdoclet.collector.jaxrs.JaxRSCollector;
import org.calrissian.restdoclet.collector.spring.SpringCollector;
import org.calrissian.restdoclet.model.ClassDescriptor;
import org.calrissian.restdoclet.writer.Writer;
import org.calrissian.restdoclet.writer.simple.SimpleHtmlWriter;
import org.calrissian.restdoclet.writer.swagger.SwaggerWriter;

public class RestDoclet
extends Doclet {
    private static final Collection<Collector> collectors = Arrays.asList(new SpringCollector(), new JaxRSCollector());

    public static boolean start(RootDoc root) {
        Configuration config = new Configuration(root.options());
        ArrayList<ClassDescriptor> classDescriptors = new ArrayList<ClassDescriptor>();
        for (Collector collector : collectors) {
            classDescriptors.addAll(collector.getDescriptors(root));
        }
        Writer writer = config.getOutputFormat().equals("swagger") ? new SwaggerWriter() : new SimpleHtmlWriter();
        try {
            writer.write(classDescriptors, config);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int optionLength(String option) {
        return Configuration.getOptionLength(option);
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }
}

