/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.restdoclet;

public class Configuration {
    private String[][] options;

    public Configuration(String[][] options) {
        this.options = options;
    }

    public String getOutputFormat() {
        return this.getOption(ConfigOption.OUTPUT_FORMAT);
    }

    public String getDocumentTitle() {
        return this.getOption(ConfigOption.TITLE);
    }

    public String getStyleSheet() {
        return this.getOption(ConfigOption.STYLESHEET);
    }

    public String getApiVersion() {
        return this.getOption(ConfigOption.API_VERSION);
    }

    public String getPath() {
        return this.getOption(ConfigOption.BASEPATH);
    }

    public boolean isCallable() {
        return Boolean.parseBoolean(this.getOption(ConfigOption.DISPLAY_ONLY));
    }

    public boolean isdefaultStyleSheet() {
        return this.getOption(ConfigOption.STYLESHEET.getOption(), null) == null;
    }

    private String getOption(ConfigOption configOption) {
        return this.getOption(configOption.getOption(), configOption.getDefaultValue());
    }

    private String getOption(String name, String defaultValue) {
        for (String[] option : this.options) {
            if (!option[0].equals(name)) continue;
            return option[1];
        }
        return defaultValue;
    }

    public static int getOptionLength(String option) {
        for (ConfigOption configOption : ConfigOption.values()) {
            if (!option.equals(configOption.getOption())) continue;
            return 2;
        }
        return 0;
    }

    private static enum ConfigOption {
        OUTPUT_FORMAT("o", "legacy"),
        TITLE("t", "REST Endpoint Descriptions"),
        STYLESHEET("stylesheet", "./stylesheet.css"),
        API_VERSION("version", null),
        DISPLAY_ONLY("callable", "true"),
        BASEPATH("path", "/");

        private String option;
        private String defaultValue;

        private ConfigOption(String option, String defaultValue) {
            this.option = "-" + option;
            this.defaultValue = defaultValue;
        }

        public String getOption() {
            return this.option;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

