/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.mango.json.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.util.Iterator;
import org.calrissian.mango.criteria.domain.AndNode;
import org.calrissian.mango.criteria.domain.EqualsLeaf;
import org.calrissian.mango.criteria.domain.Node;
import org.calrissian.mango.criteria.domain.NotEqualsLeaf;
import org.calrissian.mango.criteria.domain.OrNode;
import org.calrissian.mango.criteria.domain.RangeLeaf;
import org.calrissian.mango.types.TypeRegistry;

public class NodeDeserializer
extends JsonDeserializer<Node> {
    private final TypeRegistry<String> typeRegistry;

    public NodeDeserializer(TypeRegistry<String> typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    public Node deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode root = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        Iterator fieldNames = root.fieldNames();
        if (fieldNames.hasNext()) {
            String fieldKey = (String)fieldNames.next();
            JsonNode fieldJson = root.get(fieldKey);
            return this.parseField(fieldKey, fieldJson);
        }
        return null;
    }

    protected Node parseField(String fieldKey, JsonNode fieldJson) throws IOException {
        switch (fieldKey) {
            case "and": {
                AndNode andNode = new AndNode();
                JsonNode children = fieldJson.get("children");
                if (children instanceof ArrayNode) {
                    ArrayNode childrenArray = (ArrayNode)children;
                    Iterator elements = childrenArray.elements();
                    while (elements.hasNext()) {
                        JsonNode entry = (JsonNode)elements.next();
                        Iterator fieldNames = entry.fieldNames();
                        while (fieldNames.hasNext()) {
                            String key = (String)fieldNames.next();
                            andNode.addChild(this.parseField(key, entry.get(key)));
                        }
                    }
                }
                return andNode;
            }
            case "or": {
                OrNode orNode = new OrNode();
                JsonNode children = fieldJson.get("children");
                if (children instanceof ArrayNode) {
                    ArrayNode childrenArray = (ArrayNode)children;
                    Iterator elements = childrenArray.elements();
                    while (elements.hasNext()) {
                        JsonNode entry = (JsonNode)elements.next();
                        Iterator fieldNames = entry.fieldNames();
                        while (fieldNames.hasNext()) {
                            String key = (String)fieldNames.next();
                            orNode.addChild(this.parseField(key, entry.get(key)));
                        }
                    }
                }
                return orNode;
            }
            case "eq": {
                String key = fieldJson.get("key").asText();
                String type = fieldJson.get("type").asText();
                String val_str = fieldJson.get("value").asText();
                Object obj = this.typeRegistry.decode(type, (Object)val_str);
                return new EqualsLeaf(key, obj, null);
            }
            case "neq": {
                String key = fieldJson.get("key").asText();
                String type = fieldJson.get("type").asText();
                String val_str = fieldJson.get("value").asText();
                Object obj = this.typeRegistry.decode(type, (Object)val_str);
                return new NotEqualsLeaf(key, obj, null);
            }
            case "range": {
                String key = fieldJson.get("key").asText();
                String type = fieldJson.get("type").asText();
                String start_str = fieldJson.get("start").asText();
                String end_str = fieldJson.get("end").asText();
                Object start = this.typeRegistry.decode(type, (Object)start_str);
                Object end = this.typeRegistry.decode(type, (Object)end_str);
                return new RangeLeaf(key, start, end, null);
            }
        }
        throw new IllegalArgumentException("Unsupported field: " + fieldKey);
    }
}

