/*
 * Decompiled with CFR 0.152.
 */
package org.calrissian.accumulorecipes.graphstore.model;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import org.calrissian.accumulorecipes.commons.support.tuple.Metadata;
import org.calrissian.mango.domain.Tuple;
import org.calrissian.mango.domain.entity.BaseEntity;
import org.calrissian.mango.domain.entity.Entity;
import org.calrissian.mango.domain.entity.EntityRelationship;

public class EdgeEntity
extends BaseEntity {
    public static final String HEAD = "head";
    public static final String TAIL = "tail";
    public static final String LABEL = "edgeLabel";

    public EdgeEntity(String type, String id, Entity head, String headVis, Entity tail, String tailVis, String label) {
        super(type, id);
        Preconditions.checkNotNull((Object)head);
        Preconditions.checkNotNull((Object)headVis);
        Preconditions.checkNotNull((Object)tail);
        Preconditions.checkNotNull((Object)tailVis);
        Preconditions.checkNotNull((Object)label);
        Tuple headTuple = new Tuple(HEAD, (Object)new EntityRelationship(head), Metadata.Visiblity.setVisibility(new HashMap(1), (String)headVis));
        Tuple tailTuple = new Tuple(TAIL, (Object)new EntityRelationship(tail), Metadata.Visiblity.setVisibility(new HashMap(1), (String)tailVis));
        this.put(headTuple);
        this.put(tailTuple);
        this.put(new Tuple(LABEL, (Object)label));
    }

    public EdgeEntity(String type, String id, Entity head, Entity tail, String label) {
        this(type, id, head, "", tail, "", label);
    }

    public EdgeEntity(Entity entity) {
        super(entity.getType(), entity.getId());
        this.putAll(entity.getTuples());
    }

    public EntityRelationship getHead() {
        if (this.get(HEAD) != null) {
            return (EntityRelationship)this.get(HEAD).getValue();
        }
        return null;
    }

    public EntityRelationship getTail() {
        if (this.get(TAIL) != null) {
            return (EntityRelationship)this.get(TAIL).getValue();
        }
        return null;
    }

    public String getLabel() {
        if (this.get(LABEL) != null) {
            return (String)this.get(LABEL).getValue();
        }
        return null;
    }
}

